/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.management.polling.PollResult;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollerFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.SecurityUserConfigurationsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.SecurityUserConfigurationInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SecurityUserConfigurationListResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

public final class SecurityUserConfigurationsClientImpl
implements SecurityUserConfigurationsClient {
    private final SecurityUserConfigurationsService service;
    private final NetworkManagementClientImpl client;

    SecurityUserConfigurationsClientImpl(NetworkManagementClientImpl client) {
        this.service = RestProxy.create(SecurityUserConfigurationsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityUserConfigurationInner>> listSinglePageAsync(String resourceGroupName, String networkManagerName, Integer top, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2024-05-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, top, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, SecurityUserConfigurationInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityUserConfigurationListResult)res.getValue()).value(), ((SecurityUserConfigurationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityUserConfigurationInner>> listSinglePageAsync(String resourceGroupName, String networkManagerName, Integer top, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2024-05-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, top, skipToken, "application/json", context).map(res -> new PagedResponseBase<Object, SecurityUserConfigurationInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityUserConfigurationListResult)res.getValue()).value(), ((SecurityUserConfigurationListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SecurityUserConfigurationInner> listAsync(String resourceGroupName, String networkManagerName, Integer top, String skipToken) {
        return new PagedFlux<SecurityUserConfigurationInner>(() -> this.listSinglePageAsync(resourceGroupName, networkManagerName, top, skipToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SecurityUserConfigurationInner> listAsync(String resourceGroupName, String networkManagerName) {
        Integer top = null;
        String skipToken = null;
        return new PagedFlux<SecurityUserConfigurationInner>(() -> this.listSinglePageAsync(resourceGroupName, networkManagerName, top, skipToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SecurityUserConfigurationInner> listAsync(String resourceGroupName, String networkManagerName, Integer top, String skipToken, Context context) {
        return new PagedFlux<SecurityUserConfigurationInner>(() -> this.listSinglePageAsync(resourceGroupName, networkManagerName, top, skipToken, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecurityUserConfigurationInner> list(String resourceGroupName, String networkManagerName) {
        Integer top = null;
        String skipToken = null;
        return new PagedIterable<SecurityUserConfigurationInner>(this.listAsync(resourceGroupName, networkManagerName, top, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecurityUserConfigurationInner> list(String resourceGroupName, String networkManagerName, Integer top, String skipToken, Context context) {
        return new PagedIterable<SecurityUserConfigurationInner>(this.listAsync(resourceGroupName, networkManagerName, top, skipToken, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecurityUserConfigurationInner>> getWithResponseAsync(String resourceGroupName, String networkManagerName, String configurationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2024-05-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, configurationName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecurityUserConfigurationInner>> getWithResponseAsync(String resourceGroupName, String networkManagerName, String configurationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2024-05-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, configurationName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SecurityUserConfigurationInner> getAsync(String resourceGroupName, String networkManagerName, String configurationName) {
        return this.getWithResponseAsync(resourceGroupName, networkManagerName, configurationName).flatMap(res -> Mono.justOrEmpty((SecurityUserConfigurationInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecurityUserConfigurationInner> getWithResponse(String resourceGroupName, String networkManagerName, String configurationName, Context context) {
        return this.getWithResponseAsync(resourceGroupName, networkManagerName, configurationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecurityUserConfigurationInner get(String resourceGroupName, String networkManagerName, String configurationName) {
        return this.getWithResponse(resourceGroupName, networkManagerName, configurationName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SecurityUserConfigurationInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String networkManagerName, String configurationName, SecurityUserConfigurationInner securityUserConfiguration) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        if (securityUserConfiguration == null) {
            return Mono.error(new IllegalArgumentException("Parameter securityUserConfiguration is required and cannot be null."));
        }
        securityUserConfiguration.validate();
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), "2024-05-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, configurationName, securityUserConfiguration, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecurityUserConfigurationInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String networkManagerName, String configurationName, SecurityUserConfigurationInner securityUserConfiguration, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        if (securityUserConfiguration == null) {
            return Mono.error(new IllegalArgumentException("Parameter securityUserConfiguration is required and cannot be null."));
        }
        securityUserConfiguration.validate();
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), "2024-05-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, configurationName, securityUserConfiguration, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SecurityUserConfigurationInner> createOrUpdateAsync(String resourceGroupName, String networkManagerName, String configurationName, SecurityUserConfigurationInner securityUserConfiguration) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, networkManagerName, configurationName, securityUserConfiguration).flatMap(res -> Mono.justOrEmpty((SecurityUserConfigurationInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecurityUserConfigurationInner> createOrUpdateWithResponse(String resourceGroupName, String networkManagerName, String configurationName, SecurityUserConfigurationInner securityUserConfiguration, Context context) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, networkManagerName, configurationName, securityUserConfiguration, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecurityUserConfigurationInner createOrUpdate(String resourceGroupName, String networkManagerName, String configurationName, SecurityUserConfigurationInner securityUserConfiguration) {
        return this.createOrUpdateWithResponse(resourceGroupName, networkManagerName, configurationName, securityUserConfiguration, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String networkManagerName, String configurationName, Boolean force) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2024-05-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, configurationName, force, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String networkManagerName, String configurationName, Boolean force, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2024-05-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, configurationName, force, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkManagerName, String configurationName, Boolean force) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, networkManagerName, configurationName, force);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkManagerName, String configurationName) {
        Boolean force = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, networkManagerName, configurationName, force);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkManagerName, String configurationName, Boolean force, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, networkManagerName, configurationName, force, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkManagerName, String configurationName) {
        Boolean force = null;
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, configurationName, force).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkManagerName, String configurationName, Boolean force, Context context) {
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, configurationName, force, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String networkManagerName, String configurationName, Boolean force) {
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, configurationName, force).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String networkManagerName, String configurationName) {
        Boolean force = null;
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, configurationName, force).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String networkManagerName, String configurationName, Boolean force, Context context) {
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, configurationName, force, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkManagerName, String configurationName) {
        Boolean force = null;
        this.deleteAsync(resourceGroupName, networkManagerName, configurationName, force).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkManagerName, String configurationName, Boolean force, Context context) {
        this.deleteAsync(resourceGroupName, networkManagerName, configurationName, force, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityUserConfigurationInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, SecurityUserConfigurationInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityUserConfigurationListResult)res.getValue()).value(), ((SecurityUserConfigurationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityUserConfigurationInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, SecurityUserConfigurationInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityUserConfigurationListResult)res.getValue()).value(), ((SecurityUserConfigurationListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    public static interface SecurityUserConfigurationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/securityUserConfigurations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityUserConfigurationListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="networkManagerName") String var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$skipToken") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/securityUserConfigurations/{configurationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityUserConfigurationInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="networkManagerName") String var5, @PathParam(value="configurationName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/securityUserConfigurations/{configurationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityUserConfigurationInner>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="networkManagerName") String var5, @PathParam(value="configurationName") String var6, @BodyParam(value="application/json") SecurityUserConfigurationInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/securityUserConfigurations/{configurationName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="networkManagerName") String var5, @PathParam(value="configurationName") String var6, @QueryParam(value="force") Boolean var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityUserConfigurationListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

