/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayFirewallRuleGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayRuleSetStatusOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayTierTypes;
import java.io.IOException;
import java.util.List;

public final class ApplicationGatewayFirewallManifestRuleSet
implements JsonSerializable<ApplicationGatewayFirewallManifestRuleSet> {
    private String ruleSetType;
    private String ruleSetVersion;
    private ApplicationGatewayRuleSetStatusOptions status;
    private List<ApplicationGatewayTierTypes> tiers;
    private List<ApplicationGatewayFirewallRuleGroup> ruleGroups;
    private static final ClientLogger LOGGER = new ClientLogger(ApplicationGatewayFirewallManifestRuleSet.class);

    public String ruleSetType() {
        return this.ruleSetType;
    }

    public ApplicationGatewayFirewallManifestRuleSet withRuleSetType(String ruleSetType) {
        this.ruleSetType = ruleSetType;
        return this;
    }

    public String ruleSetVersion() {
        return this.ruleSetVersion;
    }

    public ApplicationGatewayFirewallManifestRuleSet withRuleSetVersion(String ruleSetVersion) {
        this.ruleSetVersion = ruleSetVersion;
        return this;
    }

    public ApplicationGatewayRuleSetStatusOptions status() {
        return this.status;
    }

    public ApplicationGatewayFirewallManifestRuleSet withStatus(ApplicationGatewayRuleSetStatusOptions status) {
        this.status = status;
        return this;
    }

    public List<ApplicationGatewayTierTypes> tiers() {
        return this.tiers;
    }

    public ApplicationGatewayFirewallManifestRuleSet withTiers(List<ApplicationGatewayTierTypes> tiers) {
        this.tiers = tiers;
        return this;
    }

    public List<ApplicationGatewayFirewallRuleGroup> ruleGroups() {
        return this.ruleGroups;
    }

    public ApplicationGatewayFirewallManifestRuleSet withRuleGroups(List<ApplicationGatewayFirewallRuleGroup> ruleGroups) {
        this.ruleGroups = ruleGroups;
        return this;
    }

    public void validate() {
        if (this.ruleSetType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property ruleSetType in model ApplicationGatewayFirewallManifestRuleSet"));
        }
        if (this.ruleSetVersion() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property ruleSetVersion in model ApplicationGatewayFirewallManifestRuleSet"));
        }
        if (this.ruleGroups() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property ruleGroups in model ApplicationGatewayFirewallManifestRuleSet"));
        }
        this.ruleGroups().forEach(e -> e.validate());
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ruleSetType", this.ruleSetType);
        jsonWriter.writeStringField("ruleSetVersion", this.ruleSetVersion);
        jsonWriter.writeArrayField("ruleGroups", this.ruleGroups, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeArrayField("tiers", this.tiers, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayFirewallManifestRuleSet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayFirewallManifestRuleSet deserializedApplicationGatewayFirewallManifestRuleSet = new ApplicationGatewayFirewallManifestRuleSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ruleSetType".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallManifestRuleSet.ruleSetType = reader.getString();
                    continue;
                }
                if ("ruleSetVersion".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallManifestRuleSet.ruleSetVersion = reader.getString();
                    continue;
                }
                if ("ruleGroups".equals(fieldName)) {
                    List<ApplicationGatewayFirewallRuleGroup> ruleGroups = reader.readArray(reader1 -> ApplicationGatewayFirewallRuleGroup.fromJson(reader1));
                    deserializedApplicationGatewayFirewallManifestRuleSet.ruleGroups = ruleGroups;
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallManifestRuleSet.status = ApplicationGatewayRuleSetStatusOptions.fromString(reader.getString());
                    continue;
                }
                if ("tiers".equals(fieldName)) {
                    List<ApplicationGatewayTierTypes> tiers = reader.readArray(reader1 -> ApplicationGatewayTierTypes.fromString(reader1.getString()));
                    deserializedApplicationGatewayFirewallManifestRuleSet.tiers = tiers;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayFirewallManifestRuleSet;
        });
    }
}

