/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectionMonitorEndpointFilter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectionMonitorEndpointLocationDetails;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectionMonitorEndpointScope;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.CoverageLevel;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.EndpointType;
import java.io.IOException;

public final class ConnectionMonitorEndpoint
implements JsonSerializable<ConnectionMonitorEndpoint> {
    private String name;
    private EndpointType type;
    private String resourceId;
    private String address;
    private ConnectionMonitorEndpointFilter filter;
    private ConnectionMonitorEndpointScope scope;
    private CoverageLevel coverageLevel;
    private ConnectionMonitorEndpointLocationDetails locationDetails;
    private String subscriptionId;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectionMonitorEndpoint.class);

    public String name() {
        return this.name;
    }

    public ConnectionMonitorEndpoint withName(String name) {
        this.name = name;
        return this;
    }

    public EndpointType type() {
        return this.type;
    }

    public ConnectionMonitorEndpoint withType(EndpointType type) {
        this.type = type;
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public ConnectionMonitorEndpoint withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String address() {
        return this.address;
    }

    public ConnectionMonitorEndpoint withAddress(String address) {
        this.address = address;
        return this;
    }

    public ConnectionMonitorEndpointFilter filter() {
        return this.filter;
    }

    public ConnectionMonitorEndpoint withFilter(ConnectionMonitorEndpointFilter filter) {
        this.filter = filter;
        return this;
    }

    public ConnectionMonitorEndpointScope scope() {
        return this.scope;
    }

    public ConnectionMonitorEndpoint withScope(ConnectionMonitorEndpointScope scope) {
        this.scope = scope;
        return this;
    }

    public CoverageLevel coverageLevel() {
        return this.coverageLevel;
    }

    public ConnectionMonitorEndpoint withCoverageLevel(CoverageLevel coverageLevel) {
        this.coverageLevel = coverageLevel;
        return this;
    }

    public ConnectionMonitorEndpointLocationDetails locationDetails() {
        return this.locationDetails;
    }

    public ConnectionMonitorEndpoint withLocationDetails(ConnectionMonitorEndpointLocationDetails locationDetails) {
        this.locationDetails = locationDetails;
        return this;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public ConnectionMonitorEndpoint withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model ConnectionMonitorEndpoint"));
        }
        if (this.filter() != null) {
            this.filter().validate();
        }
        if (this.scope() != null) {
            this.scope().validate();
        }
        if (this.locationDetails() != null) {
            this.locationDetails().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("address", this.address);
        jsonWriter.writeJsonField("filter", this.filter);
        jsonWriter.writeJsonField("scope", this.scope);
        jsonWriter.writeStringField("coverageLevel", this.coverageLevel == null ? null : this.coverageLevel.toString());
        jsonWriter.writeJsonField("locationDetails", this.locationDetails);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionMonitorEndpoint fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionMonitorEndpoint deserializedConnectionMonitorEndpoint = new ConnectionMonitorEndpoint();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedConnectionMonitorEndpoint.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedConnectionMonitorEndpoint.type = EndpointType.fromString(reader.getString());
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedConnectionMonitorEndpoint.resourceId = reader.getString();
                    continue;
                }
                if ("address".equals(fieldName)) {
                    deserializedConnectionMonitorEndpoint.address = reader.getString();
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedConnectionMonitorEndpoint.filter = ConnectionMonitorEndpointFilter.fromJson(reader);
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedConnectionMonitorEndpoint.scope = ConnectionMonitorEndpointScope.fromJson(reader);
                    continue;
                }
                if ("coverageLevel".equals(fieldName)) {
                    deserializedConnectionMonitorEndpoint.coverageLevel = CoverageLevel.fromString(reader.getString());
                    continue;
                }
                if ("locationDetails".equals(fieldName)) {
                    deserializedConnectionMonitorEndpoint.locationDetails = ConnectionMonitorEndpointLocationDetails.fromJson(reader);
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedConnectionMonitorEndpoint.subscriptionId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionMonitorEndpoint;
        });
    }
}

