/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectivityDestination;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectivitySource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.IpVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Protocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProtocolConfiguration;
import java.io.IOException;

public final class ConnectivityParameters
implements JsonSerializable<ConnectivityParameters> {
    private ConnectivitySource source;
    private ConnectivityDestination destination;
    private Protocol protocol;
    private ProtocolConfiguration protocolConfiguration;
    private IpVersion preferredIpVersion;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectivityParameters.class);

    public ConnectivitySource source() {
        return this.source;
    }

    public ConnectivityParameters withSource(ConnectivitySource source2) {
        this.source = source2;
        return this;
    }

    public ConnectivityDestination destination() {
        return this.destination;
    }

    public ConnectivityParameters withDestination(ConnectivityDestination destination) {
        this.destination = destination;
        return this;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public ConnectivityParameters withProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public ProtocolConfiguration protocolConfiguration() {
        return this.protocolConfiguration;
    }

    public ConnectivityParameters withProtocolConfiguration(ProtocolConfiguration protocolConfiguration) {
        this.protocolConfiguration = protocolConfiguration;
        return this;
    }

    public IpVersion preferredIpVersion() {
        return this.preferredIpVersion;
    }

    public ConnectivityParameters withPreferredIpVersion(IpVersion preferredIpVersion) {
        this.preferredIpVersion = preferredIpVersion;
        return this;
    }

    public void validate() {
        if (this.source() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property source in model ConnectivityParameters"));
        }
        this.source().validate();
        if (this.destination() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property destination in model ConnectivityParameters"));
        }
        this.destination().validate();
        if (this.protocolConfiguration() != null) {
            this.protocolConfiguration().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("source", this.source);
        jsonWriter.writeJsonField("destination", this.destination);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeJsonField("protocolConfiguration", this.protocolConfiguration);
        jsonWriter.writeStringField("preferredIPVersion", this.preferredIpVersion == null ? null : this.preferredIpVersion.toString());
        return jsonWriter.writeEndObject();
    }

    public static ConnectivityParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectivityParameters deserializedConnectivityParameters = new ConnectivityParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    deserializedConnectivityParameters.source = ConnectivitySource.fromJson(reader);
                    continue;
                }
                if ("destination".equals(fieldName)) {
                    deserializedConnectivityParameters.destination = ConnectivityDestination.fromJson(reader);
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedConnectivityParameters.protocol = Protocol.fromString(reader.getString());
                    continue;
                }
                if ("protocolConfiguration".equals(fieldName)) {
                    deserializedConnectivityParameters.protocolConfiguration = ProtocolConfiguration.fromJson(reader);
                    continue;
                }
                if ("preferredIPVersion".equals(fieldName)) {
                    deserializedConnectivityParameters.preferredIpVersion = IpVersion.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectivityParameters;
        });
    }
}

