/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ServiceDelegationPropertiesFormat;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class Delegation
extends SubResource {
    private ServiceDelegationPropertiesFormat innerProperties;
    private String name;
    private String etag;
    private String type;

    private ServiceDelegationPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public Delegation withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public Delegation withType(String type) {
        this.type = type;
        return this;
    }

    @Override
    public Delegation withId(String id) {
        super.withId(id);
        return this;
    }

    public String serviceName() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceName();
    }

    public Delegation withServiceName(String serviceName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServiceDelegationPropertiesFormat();
        }
        this.innerProperties().withServiceName(serviceName);
        return this;
    }

    public List<String> actions() {
        return this.innerProperties() == null ? null : this.innerProperties().actions();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static Delegation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Delegation deserializedDelegation = new Delegation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDelegation.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDelegation.innerProperties = ServiceDelegationPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDelegation.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedDelegation.etag = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDelegation.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDelegation;
        });
    }
}

