/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.HttpHeader;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.HttpMethod;
import java.io.IOException;
import java.util.List;

public final class HttpConfiguration
implements JsonSerializable<HttpConfiguration> {
    private HttpMethod method;
    private List<HttpHeader> headers;
    private List<Integer> validStatusCodes;

    public HttpMethod method() {
        return this.method;
    }

    public HttpConfiguration withMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public List<HttpHeader> headers() {
        return this.headers;
    }

    public HttpConfiguration withHeaders(List<HttpHeader> headers) {
        this.headers = headers;
        return this;
    }

    public List<Integer> validStatusCodes() {
        return this.validStatusCodes;
    }

    public HttpConfiguration withValidStatusCodes(List<Integer> validStatusCodes) {
        this.validStatusCodes = validStatusCodes;
        return this;
    }

    public void validate() {
        if (this.headers() != null) {
            this.headers().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("method", this.method == null ? null : this.method.toString());
        jsonWriter.writeArrayField("headers", this.headers, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("validStatusCodes", this.validStatusCodes, (writer, element) -> writer.writeInt((int)element));
        return jsonWriter.writeEndObject();
    }

    public static HttpConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HttpConfiguration deserializedHttpConfiguration = new HttpConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("method".equals(fieldName)) {
                    deserializedHttpConfiguration.method = HttpMethod.fromString(reader.getString());
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    List<HttpHeader> headers = reader.readArray(reader1 -> HttpHeader.fromJson(reader1));
                    deserializedHttpConfiguration.headers = headers;
                    continue;
                }
                if ("validStatusCodes".equals(fieldName)) {
                    List<Integer> validStatusCodes = reader.readArray(reader1 -> reader1.getInt());
                    deserializedHttpConfiguration.validStatusCodes = validStatusCodes;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpConfiguration;
        });
    }
}

