/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.SecurityRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.EffectiveNetworkSecurityRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkInterfaceAssociation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SubnetAssociation;
import java.io.IOException;
import java.util.List;

public final class SecurityRuleAssociations
implements JsonSerializable<SecurityRuleAssociations> {
    private NetworkInterfaceAssociation networkInterfaceAssociation;
    private SubnetAssociation subnetAssociation;
    private List<SecurityRuleInner> defaultSecurityRules;
    private List<EffectiveNetworkSecurityRule> effectiveSecurityRules;

    public NetworkInterfaceAssociation networkInterfaceAssociation() {
        return this.networkInterfaceAssociation;
    }

    public SecurityRuleAssociations withNetworkInterfaceAssociation(NetworkInterfaceAssociation networkInterfaceAssociation) {
        this.networkInterfaceAssociation = networkInterfaceAssociation;
        return this;
    }

    public SubnetAssociation subnetAssociation() {
        return this.subnetAssociation;
    }

    public SecurityRuleAssociations withSubnetAssociation(SubnetAssociation subnetAssociation) {
        this.subnetAssociation = subnetAssociation;
        return this;
    }

    public List<SecurityRuleInner> defaultSecurityRules() {
        return this.defaultSecurityRules;
    }

    public SecurityRuleAssociations withDefaultSecurityRules(List<SecurityRuleInner> defaultSecurityRules) {
        this.defaultSecurityRules = defaultSecurityRules;
        return this;
    }

    public List<EffectiveNetworkSecurityRule> effectiveSecurityRules() {
        return this.effectiveSecurityRules;
    }

    public SecurityRuleAssociations withEffectiveSecurityRules(List<EffectiveNetworkSecurityRule> effectiveSecurityRules) {
        this.effectiveSecurityRules = effectiveSecurityRules;
        return this;
    }

    public void validate() {
        if (this.networkInterfaceAssociation() != null) {
            this.networkInterfaceAssociation().validate();
        }
        if (this.subnetAssociation() != null) {
            this.subnetAssociation().validate();
        }
        if (this.defaultSecurityRules() != null) {
            this.defaultSecurityRules().forEach(e -> e.validate());
        }
        if (this.effectiveSecurityRules() != null) {
            this.effectiveSecurityRules().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("networkInterfaceAssociation", this.networkInterfaceAssociation);
        jsonWriter.writeJsonField("subnetAssociation", this.subnetAssociation);
        jsonWriter.writeArrayField("defaultSecurityRules", this.defaultSecurityRules, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("effectiveSecurityRules", this.effectiveSecurityRules, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static SecurityRuleAssociations fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityRuleAssociations deserializedSecurityRuleAssociations = new SecurityRuleAssociations();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("networkInterfaceAssociation".equals(fieldName)) {
                    deserializedSecurityRuleAssociations.networkInterfaceAssociation = NetworkInterfaceAssociation.fromJson(reader);
                    continue;
                }
                if ("subnetAssociation".equals(fieldName)) {
                    deserializedSecurityRuleAssociations.subnetAssociation = SubnetAssociation.fromJson(reader);
                    continue;
                }
                if ("defaultSecurityRules".equals(fieldName)) {
                    List<SecurityRuleInner> defaultSecurityRules = reader.readArray(reader1 -> SecurityRuleInner.fromJson(reader1));
                    deserializedSecurityRuleAssociations.defaultSecurityRules = defaultSecurityRules;
                    continue;
                }
                if ("effectiveSecurityRules".equals(fieldName)) {
                    List<EffectiveNetworkSecurityRule> effectiveSecurityRules = reader.readArray(reader1 -> EffectiveNetworkSecurityRule.fromJson(reader1));
                    deserializedSecurityRuleAssociations.effectiveSecurityRules = effectiveSecurityRules;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityRuleAssociations;
        });
    }
}

