/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementError;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.OperationStatusResult;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public final class OperationStatusInner
extends OperationStatusResult {
    private Map<String, Object> properties;
    private static final ClientLogger LOGGER = new ClientLogger(OperationStatusInner.class);

    public Map<String, Object> properties() {
        return this.properties;
    }

    public OperationStatusInner withProperties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public OperationStatusInner withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public OperationStatusInner withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public OperationStatusInner withStatus(String status) {
        super.withStatus(status);
        return this;
    }

    @Override
    public OperationStatusInner withPercentComplete(Float percentComplete) {
        super.withPercentComplete(percentComplete);
        return this;
    }

    @Override
    public OperationStatusInner withStartTime(OffsetDateTime startTime) {
        super.withStartTime(startTime);
        return this;
    }

    @Override
    public OperationStatusInner withEndTime(OffsetDateTime endTime) {
        super.withEndTime(endTime);
        return this;
    }

    @Override
    public OperationStatusInner withOperations(List<OperationStatusResult> operations) {
        super.withOperations(operations);
        return this;
    }

    @Override
    public OperationStatusInner withError(ManagementError error) {
        super.withError(error);
        return this;
    }

    @Override
    public void validate() {
        if (this.status() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property status in model OperationStatusInner"));
        }
        if (this.operations() != null) {
            this.operations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status());
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeNumberField("percentComplete", this.percentComplete());
        jsonWriter.writeStringField("startTime", this.startTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime()));
        jsonWriter.writeStringField("endTime", this.endTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime()));
        jsonWriter.writeArrayField("operations", this.operations(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("error", this.error());
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static OperationStatusInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationStatusInner deserializedOperationStatusInner = new OperationStatusInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedOperationStatusInner.withStatus(reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedOperationStatusInner.withId(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedOperationStatusInner.withName(reader.getString());
                    continue;
                }
                if ("percentComplete".equals(fieldName)) {
                    deserializedOperationStatusInner.withPercentComplete(reader.getNullable(JsonReader::getFloat));
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedOperationStatusInner.withStartTime(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedOperationStatusInner.withEndTime(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("operations".equals(fieldName)) {
                    List<OperationStatusResult> operations = reader.readArray(reader1 -> OperationStatusResult.fromJson(reader1));
                    deserializedOperationStatusInner.withOperations((List)operations);
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedOperationStatusInner.withError(ManagementError.fromJson(reader));
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map<String, Object> properties = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedOperationStatusInner.properties = properties;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationStatusInner;
        });
    }
}

