/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.PublicNetworkAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisCommonProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.Sku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.TlsVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.UpdateChannel;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.ZonalAllocationPolicy;
import java.io.IOException;
import java.util.Map;

public class RedisCreateProperties
extends RedisCommonProperties {
    private Sku sku;
    private String subnetId;
    private String staticIp;
    private static final ClientLogger LOGGER = new ClientLogger(RedisCreateProperties.class);

    public Sku sku() {
        return this.sku;
    }

    public RedisCreateProperties withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public RedisCreateProperties withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String staticIp() {
        return this.staticIp;
    }

    public RedisCreateProperties withStaticIp(String staticIp) {
        this.staticIp = staticIp;
        return this;
    }

    @Override
    public RedisCreateProperties withRedisConfiguration(RedisConfiguration redisConfiguration) {
        super.withRedisConfiguration(redisConfiguration);
        return this;
    }

    @Override
    public RedisCreateProperties withRedisVersion(String redisVersion) {
        super.withRedisVersion(redisVersion);
        return this;
    }

    @Override
    public RedisCreateProperties withEnableNonSslPort(Boolean enableNonSslPort) {
        super.withEnableNonSslPort(enableNonSslPort);
        return this;
    }

    @Override
    public RedisCreateProperties withReplicasPerMaster(Integer replicasPerMaster) {
        super.withReplicasPerMaster(replicasPerMaster);
        return this;
    }

    @Override
    public RedisCreateProperties withReplicasPerPrimary(Integer replicasPerPrimary) {
        super.withReplicasPerPrimary(replicasPerPrimary);
        return this;
    }

    @Override
    public RedisCreateProperties withTenantSettings(Map<String, String> tenantSettings) {
        super.withTenantSettings(tenantSettings);
        return this;
    }

    @Override
    public RedisCreateProperties withShardCount(Integer shardCount) {
        super.withShardCount(shardCount);
        return this;
    }

    @Override
    public RedisCreateProperties withMinimumTlsVersion(TlsVersion minimumTlsVersion) {
        super.withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    @Override
    public RedisCreateProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        super.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public RedisCreateProperties withUpdateChannel(UpdateChannel updateChannel) {
        super.withUpdateChannel(updateChannel);
        return this;
    }

    @Override
    public RedisCreateProperties withDisableAccessKeyAuthentication(Boolean disableAccessKeyAuthentication) {
        super.withDisableAccessKeyAuthentication(disableAccessKeyAuthentication);
        return this;
    }

    @Override
    public RedisCreateProperties withZonalAllocationPolicy(ZonalAllocationPolicy zonalAllocationPolicy) {
        super.withZonalAllocationPolicy(zonalAllocationPolicy);
        return this;
    }

    @Override
    public void validate() {
        if (this.sku() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property sku in model RedisCreateProperties"));
        }
        this.sku().validate();
        if (this.redisConfiguration() != null) {
            this.redisConfiguration().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("redisConfiguration", this.redisConfiguration());
        jsonWriter.writeStringField("redisVersion", this.redisVersion());
        jsonWriter.writeBooleanField("enableNonSslPort", this.enableNonSslPort());
        jsonWriter.writeNumberField("replicasPerMaster", this.replicasPerMaster());
        jsonWriter.writeNumberField("replicasPerPrimary", this.replicasPerPrimary());
        jsonWriter.writeMapField("tenantSettings", this.tenantSettings(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeNumberField("shardCount", this.shardCount());
        jsonWriter.writeStringField("minimumTlsVersion", this.minimumTlsVersion() == null ? null : this.minimumTlsVersion().toString());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess() == null ? null : this.publicNetworkAccess().toString());
        jsonWriter.writeStringField("updateChannel", this.updateChannel() == null ? null : this.updateChannel().toString());
        jsonWriter.writeBooleanField("disableAccessKeyAuthentication", this.disableAccessKeyAuthentication());
        jsonWriter.writeStringField("zonalAllocationPolicy", this.zonalAllocationPolicy() == null ? null : this.zonalAllocationPolicy().toString());
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeStringField("staticIP", this.staticIp);
        return jsonWriter.writeEndObject();
    }

    public static RedisCreateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisCreateProperties deserializedRedisCreateProperties = new RedisCreateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("redisConfiguration".equals(fieldName)) {
                    deserializedRedisCreateProperties.withRedisConfiguration(RedisConfiguration.fromJson(reader));
                    continue;
                }
                if ("redisVersion".equals(fieldName)) {
                    deserializedRedisCreateProperties.withRedisVersion(reader.getString());
                    continue;
                }
                if ("enableNonSslPort".equals(fieldName)) {
                    deserializedRedisCreateProperties.withEnableNonSslPort(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("replicasPerMaster".equals(fieldName)) {
                    deserializedRedisCreateProperties.withReplicasPerMaster(reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("replicasPerPrimary".equals(fieldName)) {
                    deserializedRedisCreateProperties.withReplicasPerPrimary(reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("tenantSettings".equals(fieldName)) {
                    Map<String, String> tenantSettings = reader.readMap(reader1 -> reader1.getString());
                    deserializedRedisCreateProperties.withTenantSettings((Map)tenantSettings);
                    continue;
                }
                if ("shardCount".equals(fieldName)) {
                    deserializedRedisCreateProperties.withShardCount(reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("minimumTlsVersion".equals(fieldName)) {
                    deserializedRedisCreateProperties.withMinimumTlsVersion(TlsVersion.fromString(reader.getString()));
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedRedisCreateProperties.withPublicNetworkAccess(PublicNetworkAccess.fromString(reader.getString()));
                    continue;
                }
                if ("updateChannel".equals(fieldName)) {
                    deserializedRedisCreateProperties.withUpdateChannel(UpdateChannel.fromString(reader.getString()));
                    continue;
                }
                if ("disableAccessKeyAuthentication".equals(fieldName)) {
                    deserializedRedisCreateProperties.withDisableAccessKeyAuthentication(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("zonalAllocationPolicy".equals(fieldName)) {
                    deserializedRedisCreateProperties.withZonalAllocationPolicy(ZonalAllocationPolicy.fromString(reader.getString()));
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedRedisCreateProperties.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("subnetId".equals(fieldName)) {
                    deserializedRedisCreateProperties.subnetId = reader.getString();
                    continue;
                }
                if ("staticIP".equals(fieldName)) {
                    deserializedRedisCreateProperties.staticIp = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRedisCreateProperties;
        });
    }
}

