/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.ExternalChildResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag.FunctionalTaskItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag.IndexableTaskItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag.TaskGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.exception.AggregatedManagementException;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Executable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Objects;

public abstract class ExternalChildResourceImpl<FluentModelT extends Indexable, InnerModelT, ParentImplT extends ParentT, ParentT>
extends ChildResourceImpl<InnerModelT, ParentImplT, ParentT>
implements Appliable<FluentModelT>,
Creatable<FluentModelT>,
TaskGroup.HasTaskGroup,
ExternalChildResource<FluentModelT, ParentT>,
Refreshable<FluentModelT> {
    private PendingOperation pendingOperation = PendingOperation.None;
    private final String name;
    private final ExternalChildActionTaskItem childAction;

    protected ExternalChildResourceImpl(String name, ParentImplT parent, InnerModelT innerObject) {
        super(innerObject, parent);
        this.childAction = new ExternalChildActionTaskItem(this);
        this.name = name;
    }

    protected ExternalChildResourceImpl(String key, String name, ParentImplT parent, InnerModelT innerObject) {
        super(innerObject, parent);
        this.childAction = new ExternalChildActionTaskItem(key, this);
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    public PendingOperation pendingOperation() {
        return this.pendingOperation;
    }

    public void setPendingOperation(PendingOperation pendingOperation) {
        this.pendingOperation = pendingOperation;
    }

    public void clear() {
        this.setPendingOperation(PendingOperation.None);
        this.childAction.clear();
    }

    @Override
    public TaskGroup taskGroup() {
        return this.childAction.taskGroup();
    }

    protected final FluentModelT prepareUpdate() {
        this.setPendingOperation(PendingOperation.ToBeUpdated);
        return (FluentModelT)this;
    }

    public abstract Mono<FluentModelT> createResourceAsync();

    public abstract Mono<FluentModelT> updateResourceAsync();

    public abstract Mono<Void> deleteResourceAsync();

    public String childResourceKey() {
        return this.name();
    }

    @Override
    public final FluentModelT refresh() {
        return (FluentModelT)((Indexable)this.refreshAsync().block());
    }

    @Override
    public Mono<FluentModelT> refreshAsync() {
        ExternalChildResourceImpl self = this;
        return this.getInnerAsync().map(innerModelT -> {
            self.setInner(innerModelT);
            return self;
        });
    }

    protected String addDependency(FunctionalTaskItem dependency) {
        Objects.requireNonNull(dependency);
        return this.taskGroup().addDependency(dependency);
    }

    protected String addDependency(TaskGroup.HasTaskGroup dependency) {
        Objects.requireNonNull(dependency);
        this.taskGroup().addDependencyTaskGroup(dependency.taskGroup());
        return dependency.taskGroup().key();
    }

    protected String addDependency(Creatable<? extends Indexable> creatable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)creatable);
        return this.addDependency(dependency);
    }

    protected String addDependency(Appliable<? extends Indexable> appliable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)appliable);
        return this.addDependency(dependency);
    }

    protected String addDependency(Executable<? extends Indexable> executable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)executable);
        return this.addDependency(dependency);
    }

    public String addPostRunDependent(FunctionalTaskItem dependent) {
        Objects.requireNonNull(dependent);
        return this.taskGroup().addPostRunDependent(dependent);
    }

    protected String addPostRunDependent(TaskGroup.HasTaskGroup dependent) {
        Objects.requireNonNull(dependent);
        this.taskGroup().addPostRunDependentTaskGroup(dependent.taskGroup());
        return dependent.taskGroup().key();
    }

    protected String addPostRunDependent(Creatable<? extends Indexable> creatable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)creatable);
        return this.addPostRunDependent(dependency);
    }

    protected String addPostRunDependent(Appliable<? extends Indexable> appliable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)appliable);
        return this.addPostRunDependent(dependency);
    }

    protected void addPostRunDependent(Executable<? extends Indexable> executable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)executable);
        this.addPostRunDependent(dependency);
    }

    public void beforeGroupCreateOrUpdate() {
    }

    @Override
    public Mono<FluentModelT> createAsync() {
        return this.createOrUpdateAsync();
    }

    @Override
    public FluentModelT create() {
        return (FluentModelT)((Indexable)this.createAsync().block());
    }

    @Override
    public Mono<FluentModelT> applyAsync() {
        return this.createOrUpdateAsync();
    }

    @Override
    public FluentModelT apply() {
        return (FluentModelT)((Indexable)this.applyAsync().block());
    }

    @Override
    public Mono<FluentModelT> createAsync(Context context) {
        return this.invokeTaskGroupAsync(context);
    }

    @Override
    public FluentModelT create(Context context) {
        return (FluentModelT)((Indexable)this.createAsync(context).block());
    }

    @Override
    public Mono<FluentModelT> applyAsync(Context context) {
        return this.invokeTaskGroupAsync(context);
    }

    @Override
    public FluentModelT apply(Context context) {
        return (FluentModelT)((Indexable)this.applyAsync(context).block());
    }

    private Mono<FluentModelT> createOrUpdateAsync() {
        return this.taskGroup().invokeAsync().map(indexable -> indexable).onErrorMap(AggregatedManagementException::convertToManagementException);
    }

    private Mono<FluentModelT> invokeTaskGroupAsync(Context context) {
        return this.taskGroup().invokeAsync().contextWrite(c -> c.putAll(FluxUtil.toReactorContext(context).readOnly())).map(indexable -> indexable).onErrorMap(AggregatedManagementException::convertToManagementException);
    }

    protected abstract Mono<InnerModelT> getInnerAsync();

    protected Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        return Mono.empty();
    }

    public static enum PendingOperation {
        None,
        ToBeCreated,
        ToBeUpdated,
        ToBeRemoved;

    }

    private class ExternalChildActionTaskItem
    extends IndexableTaskItem {
        private final ExternalChildResourceImpl<FluentModelT, InnerModelT, ParentImplT, ParentT> externalChild;

        ExternalChildActionTaskItem(ExternalChildResourceImpl<FluentModelT, InnerModelT, ParentImplT, ParentT> externalChild) {
            this.externalChild = externalChild;
        }

        ExternalChildActionTaskItem(String key, ExternalChildResourceImpl<FluentModelT, InnerModelT, ParentImplT, ParentT> externalChild) {
            super(key);
            this.externalChild = externalChild;
        }

        @Override
        public void beforeGroupInvoke() {
            this.externalChild.beforeGroupCreateOrUpdate();
        }

        @Override
        public Mono<Indexable> invokeTaskAsync(TaskGroup.InvocationContext context) {
            switch (this.externalChild.pendingOperation().ordinal()) {
                case 1: {
                    return this.externalChild.createResourceAsync().doOnNext(createdExternalChild -> this.externalChild.setPendingOperation(PendingOperation.None)).map(createdExternalChild -> createdExternalChild);
                }
                case 2: {
                    return this.externalChild.updateResourceAsync().doOnNext(createdExternalChild -> this.externalChild.setPendingOperation(PendingOperation.None)).map(updatedExternalChild -> updatedExternalChild);
                }
                case 3: {
                    return this.externalChild.deleteResourceAsync().doOnSuccess(aVoid -> this.externalChild.setPendingOperation(PendingOperation.None)).map(aVoid -> this.voidIndexable());
                }
            }
            return Mono.error(new IllegalStateException(String.format("No action pending on child resource: %s, invokeAsync should not be called ", this.externalChild.name)));
        }

        @Override
        public Mono<Void> invokeAfterPostRunAsync(boolean isGroupFaulted) {
            return this.externalChild.afterPostRunAsync(isGroupFaulted);
        }
    }
}

