/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag.DAGNode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag.ErroredDependencyTaskException;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag.TaskGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag.TaskItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class TaskGroupEntry<TaskT extends TaskItem>
extends DAGNode<TaskT, TaskGroupEntry<TaskT>> {
    private TaskGroupEntry<TaskT> proxy;
    private boolean hasFaultedDescentDependencyTasks;

    TaskGroupEntry(String taskId, TaskT taskItem) {
        super(taskId, taskItem);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.hasFaultedDescentDependencyTasks = false;
    }

    public void setProxy(TaskGroupEntry<TaskT> proxy) {
        this.proxy = proxy;
    }

    public TaskGroupEntry<TaskT> proxy() {
        return this.proxy;
    }

    public Indexable taskResult() {
        return this.taskItem().result();
    }

    public boolean hasFaultedDescentDependencyTasks() {
        return this.hasFaultedDescentDependencyTasks;
    }

    public Mono<Indexable> invokeTaskAsync(boolean ignoreCachedResult, TaskGroup.InvocationContext context) {
        if (this.hasFaultedDescentDependencyTasks) {
            return Mono.error(new ErroredDependencyTaskException());
        }
        Object taskItem = this.taskItem();
        if (!ignoreCachedResult && this.hasCachedResult()) {
            return Mono.just(taskItem.result());
        }
        if (taskItem.isHot()) {
            return Mono.defer(() -> taskItem.invokeAsync(context));
        }
        return taskItem.invokeAsync(context);
    }

    @Override
    protected void onFaultedResolution(String dependencyKey, Throwable throwable) {
        super.onFaultedResolution(dependencyKey, throwable);
        this.hasFaultedDescentDependencyTasks = true;
    }

    private TaskT taskItem() {
        return (TaskT)((TaskItem)super.data());
    }

    private boolean hasCachedResult() {
        return this.taskItem().result() != null;
    }
}

