/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.policy;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineCallContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpLogOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.UserAgentUtil;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public class UserAgentPolicy
implements HttpPipelinePolicy {
    private static final String USER_AGENT_KEY = "User-Agent";
    private static final String SDK_NAME_KEY = "Sdk-Name";
    private static final String SDK_VERSION_KEY = "Sdk-Version";
    private static final String APPLICATION_ID_KEY = "Application-Id";
    private final String defaultSdkName = this.getClass().getPackage().getName();
    private final String defaultSdkVersion = this.getClass().getPackage().getSpecificationVersion();
    private final HttpLogOptions httpLogOptions;
    private final Configuration configuration;

    public UserAgentPolicy(HttpLogOptions httpLogOptions, Configuration configuration) {
        this.httpLogOptions = httpLogOptions == null ? new HttpLogOptions() : httpLogOptions;
        this.configuration = configuration == null ? Configuration.getGlobalConfiguration() : configuration;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        String applicationId;
        String sdkVersion;
        String userAgent = context.getHttpRequest().getHeaders().getValue(USER_AGENT_KEY);
        if (!CoreUtils.isNullOrEmpty(userAgent)) {
            return next.process();
        }
        userAgent = context.getData(USER_AGENT_KEY).orElse("").toString();
        if (!CoreUtils.isNullOrEmpty(userAgent)) {
            context.getHttpRequest().setHeader(USER_AGENT_KEY, userAgent);
            return next.process();
        }
        String sdkName = context.getData(SDK_NAME_KEY).orElse("").toString();
        if (CoreUtils.isNullOrEmpty(sdkName)) {
            sdkName = this.defaultSdkName;
        }
        if (CoreUtils.isNullOrEmpty(sdkVersion = context.getData(SDK_VERSION_KEY).orElse("").toString())) {
            sdkVersion = this.defaultSdkVersion;
        }
        if (CoreUtils.isNullOrEmpty(applicationId = context.getData(APPLICATION_ID_KEY).orElse("").toString())) {
            applicationId = this.httpLogOptions.getApplicationId();
        }
        context.getHttpRequest().setHeader(USER_AGENT_KEY, UserAgentUtil.toUserAgentString(applicationId, sdkName, sdkVersion, this.configuration));
        return next.process();
    }
}

