/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.ResourceGroupsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.ResourceManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.models.ResourceGroupExportResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.models.ResourceGroupInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation.ResourceGroupExportResultImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ExportTemplateRequest;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ResourceGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ResourceGroupExportResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ResourceGroupExportTemplateOptions;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ResourceGroupImpl
extends CreatableUpdatableImpl<ResourceGroup, ResourceGroupInner, ResourceGroupImpl>
implements ResourceGroup,
ResourceGroup.Definition,
ResourceGroup.Update {
    private final ResourceGroupsClient client;

    protected ResourceGroupImpl(ResourceGroupInner innerModel, String name, ResourceManagementClient serviceClient) {
        super(name, innerModel);
        this.client = serviceClient.getResourceGroups();
    }

    @Override
    public String provisioningState() {
        return ((ResourceGroupInner)this.innerModel()).properties().provisioningState();
    }

    @Override
    public String regionName() {
        return ((ResourceGroupInner)this.innerModel()).location();
    }

    @Override
    public Region region() {
        return Region.fromName(this.regionName());
    }

    @Override
    public String id() {
        return ((ResourceGroupInner)this.innerModel()).id();
    }

    @Override
    public String type() {
        return null;
    }

    @Override
    public Map<String, String> tags() {
        Map<String, String> tags = ((ResourceGroupInner)this.innerModel()).tags();
        if (tags == null) {
            tags = new HashMap<String, String>();
        }
        return Collections.unmodifiableMap(tags);
    }

    @Override
    public ResourceGroupExportResult exportTemplate(ResourceGroupExportTemplateOptions options) {
        return this.exportTemplateAsync(options).block();
    }

    @Override
    public Mono<ResourceGroupExportResult> exportTemplateAsync(ResourceGroupExportTemplateOptions options) {
        ExportTemplateRequest inner = new ExportTemplateRequest().withResources(Arrays.asList("*")).withOptions(options.toString());
        return this.client.exportTemplateAsync(this.name(), inner).map(resourceGroupExportResultInner -> new ResourceGroupExportResultImpl((ResourceGroupExportResultInner)resourceGroupExportResultInner));
    }

    @Override
    public ResourceGroupImpl withRegion(String regionName) {
        ((ResourceGroupInner)this.innerModel()).withLocation(regionName);
        return this;
    }

    @Override
    public ResourceGroupImpl withRegion(Region region) {
        return this.withRegion(region.toString());
    }

    @Override
    public ResourceGroupImpl withTags(Map<String, String> tags) {
        ((ResourceGroupInner)this.innerModel()).withTags(new HashMap<String, String>(tags));
        return this;
    }

    @Override
    public ResourceGroupImpl withTag(String key, String value) {
        if (((ResourceGroupInner)this.innerModel()).tags() == null) {
            ((ResourceGroupInner)this.innerModel()).withTags((Map)new HashMap());
        }
        ((ResourceGroupInner)this.innerModel()).tags().put(key, value);
        return this;
    }

    @Override
    public ResourceGroupImpl withoutTag(String key) {
        ((ResourceGroupInner)this.innerModel()).tags().remove(key);
        return this;
    }

    @Override
    public Mono<ResourceGroup> createResourceAsync() {
        ResourceGroupInner params = new ResourceGroupInner();
        params.withLocation(((ResourceGroupInner)this.innerModel()).location());
        params.withTags((Map)((ResourceGroupInner)this.innerModel()).tags());
        return this.client.createOrUpdateAsync(this.name(), params).map(this.innerToFluentMap(this));
    }

    @Override
    public Mono<ResourceGroup> updateResourceAsync() {
        return this.createResourceAsync();
    }

    @Override
    public boolean isInCreateMode() {
        return ((ResourceGroupInner)this.innerModel()).id() == null;
    }

    @Override
    protected Mono<ResourceGroupInner> getInnerAsync() {
        return this.client.getAsync(this.key);
    }
}

