/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.ResourceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.ResourceManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation.TagResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.TagOperations;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.TagResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.Tags;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.TagsPatchOperation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.TagsPatchResource;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class TagOperationsImpl
implements TagOperations {
    private final ResourceManager myManager;

    public TagOperationsImpl(ResourceManager resourceManager) {
        this.myManager = resourceManager;
    }

    @Override
    public TagResource updateTags(Resource resource, Map<String, String> tags) {
        return this.updateTagsAsync(resource, tags).block();
    }

    @Override
    public TagResource updateTags(String resourceId, Map<String, String> tags) {
        return this.updateTagsAsync(resourceId, tags).block();
    }

    @Override
    public Mono<TagResource> updateTagsAsync(Resource resource, Map<String, String> tags) {
        return this.updateTagsAsync(Objects.requireNonNull(resource).id(), tags);
    }

    @Override
    public Mono<TagResource> updateTagsAsync(String resourceId, Map<String, String> tags) {
        TagsPatchResource parameters = new TagsPatchResource().withOperation(TagsPatchOperation.REPLACE).withProperties(new Tags().withTags(new TreeMap<String, String>(tags)));
        return ((ResourceManagementClient)this.manager().serviceClient()).getTagOperations().updateAtScopeAsync(ResourceUtils.encodeResourceId(resourceId), parameters).map(TagResourceImpl::new);
    }

    @Override
    public ResourceManager manager() {
        return this.myManager;
    }
}

