/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.PairedRegion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.RegionCategory;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.RegionType;
import java.io.IOException;
import java.util.List;

public final class LocationMetadata
implements JsonSerializable<LocationMetadata> {
    private RegionType regionType;
    private RegionCategory regionCategory;
    private String geography;
    private String geographyGroup;
    private String longitude;
    private String latitude;
    private String physicalLocation;
    private List<PairedRegion> pairedRegion;
    private String homeLocation;

    public RegionType regionType() {
        return this.regionType;
    }

    public RegionCategory regionCategory() {
        return this.regionCategory;
    }

    public String geography() {
        return this.geography;
    }

    public String geographyGroup() {
        return this.geographyGroup;
    }

    public String longitude() {
        return this.longitude;
    }

    public String latitude() {
        return this.latitude;
    }

    public String physicalLocation() {
        return this.physicalLocation;
    }

    public List<PairedRegion> pairedRegion() {
        return this.pairedRegion;
    }

    public LocationMetadata withPairedRegion(List<PairedRegion> pairedRegion) {
        this.pairedRegion = pairedRegion;
        return this;
    }

    public String homeLocation() {
        return this.homeLocation;
    }

    public void validate() {
        if (this.pairedRegion() != null) {
            this.pairedRegion().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("pairedRegion", this.pairedRegion, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static LocationMetadata fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LocationMetadata deserializedLocationMetadata = new LocationMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("regionType".equals(fieldName)) {
                    deserializedLocationMetadata.regionType = RegionType.fromString(reader.getString());
                    continue;
                }
                if ("regionCategory".equals(fieldName)) {
                    deserializedLocationMetadata.regionCategory = RegionCategory.fromString(reader.getString());
                    continue;
                }
                if ("geography".equals(fieldName)) {
                    deserializedLocationMetadata.geography = reader.getString();
                    continue;
                }
                if ("geographyGroup".equals(fieldName)) {
                    deserializedLocationMetadata.geographyGroup = reader.getString();
                    continue;
                }
                if ("longitude".equals(fieldName)) {
                    deserializedLocationMetadata.longitude = reader.getString();
                    continue;
                }
                if ("latitude".equals(fieldName)) {
                    deserializedLocationMetadata.latitude = reader.getString();
                    continue;
                }
                if ("physicalLocation".equals(fieldName)) {
                    deserializedLocationMetadata.physicalLocation = reader.getString();
                    continue;
                }
                if ("pairedRegion".equals(fieldName)) {
                    List<PairedRegion> pairedRegion = reader.readArray(reader1 -> PairedRegion.fromJson(reader1));
                    deserializedLocationMetadata.pairedRegion = pairedRegion;
                    continue;
                }
                if ("homeLocation".equals(fieldName)) {
                    deserializedLocationMetadata.homeLocation = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLocationMetadata;
        });
    }
}

