/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ParameterValuesValue;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class PolicyDefinitionReference
implements JsonSerializable<PolicyDefinitionReference> {
    private String policyDefinitionId;
    private String definitionVersion;
    private String latestDefinitionVersion;
    private String effectiveDefinitionVersion;
    private Map<String, ParameterValuesValue> parameters;
    private String policyDefinitionReferenceId;
    private List<String> groupNames;
    private static final ClientLogger LOGGER = new ClientLogger(PolicyDefinitionReference.class);

    public String policyDefinitionId() {
        return this.policyDefinitionId;
    }

    public PolicyDefinitionReference withPolicyDefinitionId(String policyDefinitionId) {
        this.policyDefinitionId = policyDefinitionId;
        return this;
    }

    public String definitionVersion() {
        return this.definitionVersion;
    }

    public PolicyDefinitionReference withDefinitionVersion(String definitionVersion) {
        this.definitionVersion = definitionVersion;
        return this;
    }

    public String latestDefinitionVersion() {
        return this.latestDefinitionVersion;
    }

    public String effectiveDefinitionVersion() {
        return this.effectiveDefinitionVersion;
    }

    public Map<String, ParameterValuesValue> parameters() {
        return this.parameters;
    }

    public PolicyDefinitionReference withParameters(Map<String, ParameterValuesValue> parameters) {
        this.parameters = parameters;
        return this;
    }

    public String policyDefinitionReferenceId() {
        return this.policyDefinitionReferenceId;
    }

    public PolicyDefinitionReference withPolicyDefinitionReferenceId(String policyDefinitionReferenceId) {
        this.policyDefinitionReferenceId = policyDefinitionReferenceId;
        return this;
    }

    public List<String> groupNames() {
        return this.groupNames;
    }

    public PolicyDefinitionReference withGroupNames(List<String> groupNames) {
        this.groupNames = groupNames;
        return this;
    }

    public void validate() {
        if (this.policyDefinitionId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property policyDefinitionId in model PolicyDefinitionReference"));
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("policyDefinitionId", this.policyDefinitionId);
        jsonWriter.writeStringField("definitionVersion", this.definitionVersion);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("policyDefinitionReferenceId", this.policyDefinitionReferenceId);
        jsonWriter.writeArrayField("groupNames", this.groupNames, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static PolicyDefinitionReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyDefinitionReference deserializedPolicyDefinitionReference = new PolicyDefinitionReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policyDefinitionId".equals(fieldName)) {
                    deserializedPolicyDefinitionReference.policyDefinitionId = reader.getString();
                    continue;
                }
                if ("definitionVersion".equals(fieldName)) {
                    deserializedPolicyDefinitionReference.definitionVersion = reader.getString();
                    continue;
                }
                if ("latestDefinitionVersion".equals(fieldName)) {
                    deserializedPolicyDefinitionReference.latestDefinitionVersion = reader.getString();
                    continue;
                }
                if ("effectiveDefinitionVersion".equals(fieldName)) {
                    deserializedPolicyDefinitionReference.effectiveDefinitionVersion = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map<String, ParameterValuesValue> parameters = reader.readMap(reader1 -> ParameterValuesValue.fromJson(reader1));
                    deserializedPolicyDefinitionReference.parameters = parameters;
                    continue;
                }
                if ("policyDefinitionReferenceId".equals(fieldName)) {
                    deserializedPolicyDefinitionReference.policyDefinitionReferenceId = reader.getString();
                    continue;
                }
                if ("groupNames".equals(fieldName)) {
                    List<String> groupNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedPolicyDefinitionReference.groupNames = groupNames;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyDefinitionReference;
        });
    }
}

