/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.models.PrivateEndpointConnectionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.models.SharedPrivateLinkResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.DataPlaneAuthOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.EncryptionWithCmk;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.HostingMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.NetworkRuleSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.PublicNetworkAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.SearchSemanticSearch;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.SearchServiceStatus;
import java.io.IOException;
import java.util.List;

public final class SearchServiceProperties
implements JsonSerializable<SearchServiceProperties> {
    private Integer replicaCount;
    private Integer partitionCount;
    private HostingMode hostingMode;
    private PublicNetworkAccess publicNetworkAccess;
    private SearchServiceStatus status;
    private String statusDetails;
    private ProvisioningState provisioningState;
    private NetworkRuleSet networkRuleSet;
    private EncryptionWithCmk encryptionWithCmk;
    private Boolean disableLocalAuth;
    private DataPlaneAuthOptions authOptions;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private SearchSemanticSearch semanticSearch;
    private List<SharedPrivateLinkResourceInner> sharedPrivateLinkResources;

    public Integer replicaCount() {
        return this.replicaCount;
    }

    public SearchServiceProperties withReplicaCount(Integer replicaCount) {
        this.replicaCount = replicaCount;
        return this;
    }

    public Integer partitionCount() {
        return this.partitionCount;
    }

    public SearchServiceProperties withPartitionCount(Integer partitionCount) {
        this.partitionCount = partitionCount;
        return this;
    }

    public HostingMode hostingMode() {
        return this.hostingMode;
    }

    public SearchServiceProperties withHostingMode(HostingMode hostingMode) {
        this.hostingMode = hostingMode;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public SearchServiceProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public SearchServiceStatus status() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.networkRuleSet;
    }

    public SearchServiceProperties withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        this.networkRuleSet = networkRuleSet;
        return this;
    }

    public EncryptionWithCmk encryptionWithCmk() {
        return this.encryptionWithCmk;
    }

    public SearchServiceProperties withEncryptionWithCmk(EncryptionWithCmk encryptionWithCmk) {
        this.encryptionWithCmk = encryptionWithCmk;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public SearchServiceProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public DataPlaneAuthOptions authOptions() {
        return this.authOptions;
    }

    public SearchServiceProperties withAuthOptions(DataPlaneAuthOptions authOptions) {
        this.authOptions = authOptions;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public SearchSemanticSearch semanticSearch() {
        return this.semanticSearch;
    }

    public SearchServiceProperties withSemanticSearch(SearchSemanticSearch semanticSearch) {
        this.semanticSearch = semanticSearch;
        return this;
    }

    public List<SharedPrivateLinkResourceInner> sharedPrivateLinkResources() {
        return this.sharedPrivateLinkResources;
    }

    public void validate() {
        if (this.networkRuleSet() != null) {
            this.networkRuleSet().validate();
        }
        if (this.encryptionWithCmk() != null) {
            this.encryptionWithCmk().validate();
        }
        if (this.authOptions() != null) {
            this.authOptions().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.sharedPrivateLinkResources() != null) {
            this.sharedPrivateLinkResources().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("replicaCount", this.replicaCount);
        jsonWriter.writeNumberField("partitionCount", this.partitionCount);
        jsonWriter.writeStringField("hostingMode", this.hostingMode == null ? null : this.hostingMode.toString());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeJsonField("networkRuleSet", this.networkRuleSet);
        jsonWriter.writeJsonField("encryptionWithCmk", this.encryptionWithCmk);
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        jsonWriter.writeJsonField("authOptions", this.authOptions);
        jsonWriter.writeStringField("semanticSearch", this.semanticSearch == null ? null : this.semanticSearch.toString());
        return jsonWriter.writeEndObject();
    }

    public static SearchServiceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SearchServiceProperties deserializedSearchServiceProperties = new SearchServiceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("replicaCount".equals(fieldName)) {
                    deserializedSearchServiceProperties.replicaCount = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("partitionCount".equals(fieldName)) {
                    deserializedSearchServiceProperties.partitionCount = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("hostingMode".equals(fieldName)) {
                    deserializedSearchServiceProperties.hostingMode = HostingMode.fromString(reader.getString());
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedSearchServiceProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSearchServiceProperties.status = SearchServiceStatus.fromString(reader.getString());
                    continue;
                }
                if ("statusDetails".equals(fieldName)) {
                    deserializedSearchServiceProperties.statusDetails = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSearchServiceProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("networkRuleSet".equals(fieldName)) {
                    deserializedSearchServiceProperties.networkRuleSet = NetworkRuleSet.fromJson(reader);
                    continue;
                }
                if ("encryptionWithCmk".equals(fieldName)) {
                    deserializedSearchServiceProperties.encryptionWithCmk = EncryptionWithCmk.fromJson(reader);
                    continue;
                }
                if ("disableLocalAuth".equals(fieldName)) {
                    deserializedSearchServiceProperties.disableLocalAuth = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("authOptions".equals(fieldName)) {
                    deserializedSearchServiceProperties.authOptions = DataPlaneAuthOptions.fromJson(reader);
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List<PrivateEndpointConnectionInner> privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    deserializedSearchServiceProperties.privateEndpointConnections = privateEndpointConnections;
                    continue;
                }
                if ("semanticSearch".equals(fieldName)) {
                    deserializedSearchServiceProperties.semanticSearch = SearchSemanticSearch.fromString(reader.getString());
                    continue;
                }
                if ("sharedPrivateLinkResources".equals(fieldName)) {
                    List<SharedPrivateLinkResourceInner> sharedPrivateLinkResources = reader.readArray(reader1 -> SharedPrivateLinkResourceInner.fromJson(reader1));
                    deserializedSearchServiceProperties.sharedPrivateLinkResources = sharedPrivateLinkResources;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSearchServiceProperties;
        });
    }
}

