/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.QueryKeysClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.models.QueryKeyInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation.SearchManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.ListQueryKeysResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.UUID;

public final class QueryKeysClientImpl
implements QueryKeysClient {
    private final QueryKeysService service;
    private final SearchManagementClientImpl client;

    QueryKeysClientImpl(SearchManagementClientImpl client) {
        this.service = RestProxy.create(QueryKeysService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueryKeyInner>> createWithResponseAsync(String resourceGroupName, String searchServiceName, String name, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, searchServiceName, name, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<QueryKeyInner>> createWithResponseAsync(String resourceGroupName, String searchServiceName, String name, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, searchServiceName, name, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueryKeyInner> createAsync(String resourceGroupName, String searchServiceName, String name) {
        UUID clientRequestId = null;
        return this.createWithResponseAsync(resourceGroupName, searchServiceName, name, clientRequestId).flatMap(res -> Mono.justOrEmpty((QueryKeyInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueryKeyInner> createWithResponse(String resourceGroupName, String searchServiceName, String name, UUID clientRequestId, Context context) {
        return this.createWithResponseAsync(resourceGroupName, searchServiceName, name, clientRequestId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueryKeyInner create(String resourceGroupName, String searchServiceName, String name) {
        UUID clientRequestId = null;
        return this.createWithResponse(resourceGroupName, searchServiceName, name, clientRequestId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<QueryKeyInner>> listBySearchServiceSinglePageAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySearchService(this.client.getEndpoint(), resourceGroupName, searchServiceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, QueryKeyInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListQueryKeysResult)res.getValue()).value(), ((ListQueryKeysResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<QueryKeyInner>> listBySearchServiceSinglePageAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySearchService(this.client.getEndpoint(), resourceGroupName, searchServiceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase<Object, QueryKeyInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListQueryKeysResult)res.getValue()).value(), ((ListQueryKeysResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<QueryKeyInner> listBySearchServiceAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId) {
        return new PagedFlux<QueryKeyInner>(() -> this.listBySearchServiceSinglePageAsync(resourceGroupName, searchServiceName, clientRequestId), nextLink -> this.listBySearchServiceNextSinglePageAsync((String)nextLink, clientRequestId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<QueryKeyInner> listBySearchServiceAsync(String resourceGroupName, String searchServiceName) {
        UUID clientRequestId = null;
        return new PagedFlux<QueryKeyInner>(() -> this.listBySearchServiceSinglePageAsync(resourceGroupName, searchServiceName, clientRequestId), nextLink -> this.listBySearchServiceNextSinglePageAsync((String)nextLink, clientRequestId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<QueryKeyInner> listBySearchServiceAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId, Context context) {
        return new PagedFlux<QueryKeyInner>(() -> this.listBySearchServiceSinglePageAsync(resourceGroupName, searchServiceName, clientRequestId, context), nextLink -> this.listBySearchServiceNextSinglePageAsync((String)nextLink, clientRequestId, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueryKeyInner> listBySearchService(String resourceGroupName, String searchServiceName) {
        UUID clientRequestId = null;
        return new PagedIterable<QueryKeyInner>(this.listBySearchServiceAsync(resourceGroupName, searchServiceName, clientRequestId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueryKeyInner> listBySearchService(String resourceGroupName, String searchServiceName, UUID clientRequestId, Context context) {
        return new PagedIterable<QueryKeyInner>(this.listBySearchServiceAsync(resourceGroupName, searchServiceName, clientRequestId, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String searchServiceName, String key, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (key == null) {
            return Mono.error(new IllegalArgumentException("Parameter key is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, searchServiceName, key, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String searchServiceName, String key, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (key == null) {
            return Mono.error(new IllegalArgumentException("Parameter key is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, searchServiceName, key, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String searchServiceName, String key) {
        UUID clientRequestId = null;
        return this.deleteWithResponseAsync(resourceGroupName, searchServiceName, key, clientRequestId).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String searchServiceName, String key, UUID clientRequestId, Context context) {
        return this.deleteWithResponseAsync(resourceGroupName, searchServiceName, key, clientRequestId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String searchServiceName, String key) {
        UUID clientRequestId = null;
        this.deleteWithResponse(resourceGroupName, searchServiceName, key, clientRequestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<QueryKeyInner>> listBySearchServiceNextSinglePageAsync(String nextLink, UUID clientRequestId) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySearchServiceNext(nextLink, this.client.getEndpoint(), clientRequestId, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, QueryKeyInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListQueryKeysResult)res.getValue()).value(), ((ListQueryKeysResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<QueryKeyInner>> listBySearchServiceNextSinglePageAsync(String nextLink, UUID clientRequestId, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySearchServiceNext(nextLink, this.client.getEndpoint(), clientRequestId, "application/json", context).map(res -> new PagedResponseBase<Object, QueryKeyInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ListQueryKeysResult)res.getValue()).value(), ((ListQueryKeysResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SearchManagementClie")
    public static interface QueryKeysService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/createQueryKey/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<QueryKeyInner>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="searchServiceName") String var3, @PathParam(value="name") String var4, @HeaderParam(value="x-ms-client-request-id") UUID var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/listQueryKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ListQueryKeysResult>> listBySearchService(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="searchServiceName") String var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/deleteQueryKey/{key}")
        @ExpectedResponses(value={200, 204, 404})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="searchServiceName") String var3, @PathParam(value="key") String var4, @HeaderParam(value="x-ms-client-request-id") UUID var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ListQueryKeysResult>> listBySearchServiceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

