/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation.DurationSerializer;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.MessageCountDetails;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;

public final class SBQueueProperties
implements JsonSerializable<SBQueueProperties> {
    private MessageCountDetails countDetails;
    private OffsetDateTime createdAt;
    private OffsetDateTime updatedAt;
    private OffsetDateTime accessedAt;
    private Long sizeInBytes;
    private Long messageCount;
    private Duration lockDuration;
    private Integer maxSizeInMegabytes;
    private Long maxMessageSizeInKilobytes;
    private Boolean requiresDuplicateDetection;
    private Boolean requiresSession;
    private Duration defaultMessageTimeToLive;
    private Boolean deadLetteringOnMessageExpiration;
    private Duration duplicateDetectionHistoryTimeWindow;
    private Integer maxDeliveryCount;
    private EntityStatus status;
    private Boolean enableBatchedOperations;
    private Duration autoDeleteOnIdle;
    private Boolean enablePartitioning;
    private Boolean enableExpress;
    private String forwardTo;
    private String forwardDeadLetteredMessagesTo;

    public MessageCountDetails countDetails() {
        return this.countDetails;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public OffsetDateTime accessedAt() {
        return this.accessedAt;
    }

    public Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public Long messageCount() {
        return this.messageCount;
    }

    public Duration lockDuration() {
        return this.lockDuration;
    }

    public SBQueueProperties withLockDuration(Duration lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    public Integer maxSizeInMegabytes() {
        return this.maxSizeInMegabytes;
    }

    public SBQueueProperties withMaxSizeInMegabytes(Integer maxSizeInMegabytes) {
        this.maxSizeInMegabytes = maxSizeInMegabytes;
        return this;
    }

    public Long maxMessageSizeInKilobytes() {
        return this.maxMessageSizeInKilobytes;
    }

    public SBQueueProperties withMaxMessageSizeInKilobytes(Long maxMessageSizeInKilobytes) {
        this.maxMessageSizeInKilobytes = maxMessageSizeInKilobytes;
        return this;
    }

    public Boolean requiresDuplicateDetection() {
        return this.requiresDuplicateDetection;
    }

    public SBQueueProperties withRequiresDuplicateDetection(Boolean requiresDuplicateDetection) {
        this.requiresDuplicateDetection = requiresDuplicateDetection;
        return this;
    }

    public Boolean requiresSession() {
        return this.requiresSession;
    }

    public SBQueueProperties withRequiresSession(Boolean requiresSession) {
        this.requiresSession = requiresSession;
        return this;
    }

    public Duration defaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public SBQueueProperties withDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    public Boolean deadLetteringOnMessageExpiration() {
        return this.deadLetteringOnMessageExpiration;
    }

    public SBQueueProperties withDeadLetteringOnMessageExpiration(Boolean deadLetteringOnMessageExpiration) {
        this.deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
        return this;
    }

    public Duration duplicateDetectionHistoryTimeWindow() {
        return this.duplicateDetectionHistoryTimeWindow;
    }

    public SBQueueProperties withDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
        this.duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow;
        return this;
    }

    public Integer maxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public SBQueueProperties withMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    public EntityStatus status() {
        return this.status;
    }

    public SBQueueProperties withStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public Boolean enableBatchedOperations() {
        return this.enableBatchedOperations;
    }

    public SBQueueProperties withEnableBatchedOperations(Boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    public Duration autoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public SBQueueProperties withAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    public Boolean enablePartitioning() {
        return this.enablePartitioning;
    }

    public SBQueueProperties withEnablePartitioning(Boolean enablePartitioning) {
        this.enablePartitioning = enablePartitioning;
        return this;
    }

    public Boolean enableExpress() {
        return this.enableExpress;
    }

    public SBQueueProperties withEnableExpress(Boolean enableExpress) {
        this.enableExpress = enableExpress;
        return this;
    }

    public String forwardTo() {
        return this.forwardTo;
    }

    public SBQueueProperties withForwardTo(String forwardTo) {
        this.forwardTo = forwardTo;
        return this;
    }

    public String forwardDeadLetteredMessagesTo() {
        return this.forwardDeadLetteredMessagesTo;
    }

    public SBQueueProperties withForwardDeadLetteredMessagesTo(String forwardDeadLetteredMessagesTo) {
        this.forwardDeadLetteredMessagesTo = forwardDeadLetteredMessagesTo;
        return this;
    }

    public void validate() {
        if (this.countDetails() != null) {
            this.countDetails().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lockDuration", DurationSerializer.serialize(this.lockDuration));
        jsonWriter.writeNumberField("maxSizeInMegabytes", this.maxSizeInMegabytes);
        jsonWriter.writeNumberField("maxMessageSizeInKilobytes", this.maxMessageSizeInKilobytes);
        jsonWriter.writeBooleanField("requiresDuplicateDetection", this.requiresDuplicateDetection);
        jsonWriter.writeBooleanField("requiresSession", this.requiresSession);
        jsonWriter.writeStringField("defaultMessageTimeToLive", DurationSerializer.serialize(this.defaultMessageTimeToLive));
        jsonWriter.writeBooleanField("deadLetteringOnMessageExpiration", this.deadLetteringOnMessageExpiration);
        jsonWriter.writeStringField("duplicateDetectionHistoryTimeWindow", DurationSerializer.serialize(this.duplicateDetectionHistoryTimeWindow));
        jsonWriter.writeNumberField("maxDeliveryCount", this.maxDeliveryCount);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeBooleanField("enableBatchedOperations", this.enableBatchedOperations);
        jsonWriter.writeStringField("autoDeleteOnIdle", DurationSerializer.serialize(this.autoDeleteOnIdle));
        jsonWriter.writeBooleanField("enablePartitioning", this.enablePartitioning);
        jsonWriter.writeBooleanField("enableExpress", this.enableExpress);
        jsonWriter.writeStringField("forwardTo", this.forwardTo);
        jsonWriter.writeStringField("forwardDeadLetteredMessagesTo", this.forwardDeadLetteredMessagesTo);
        return jsonWriter.writeEndObject();
    }

    public static SBQueueProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SBQueueProperties deserializedSBQueueProperties = new SBQueueProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("countDetails".equals(fieldName)) {
                    deserializedSBQueueProperties.countDetails = MessageCountDetails.fromJson(reader);
                    continue;
                }
                if ("createdAt".equals(fieldName)) {
                    deserializedSBQueueProperties.createdAt = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("updatedAt".equals(fieldName)) {
                    deserializedSBQueueProperties.updatedAt = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("accessedAt".equals(fieldName)) {
                    deserializedSBQueueProperties.accessedAt = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("sizeInBytes".equals(fieldName)) {
                    deserializedSBQueueProperties.sizeInBytes = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("messageCount".equals(fieldName)) {
                    deserializedSBQueueProperties.messageCount = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("lockDuration".equals(fieldName)) {
                    deserializedSBQueueProperties.lockDuration = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("maxSizeInMegabytes".equals(fieldName)) {
                    deserializedSBQueueProperties.maxSizeInMegabytes = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxMessageSizeInKilobytes".equals(fieldName)) {
                    deserializedSBQueueProperties.maxMessageSizeInKilobytes = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("requiresDuplicateDetection".equals(fieldName)) {
                    deserializedSBQueueProperties.requiresDuplicateDetection = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("requiresSession".equals(fieldName)) {
                    deserializedSBQueueProperties.requiresSession = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultMessageTimeToLive".equals(fieldName)) {
                    deserializedSBQueueProperties.defaultMessageTimeToLive = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("deadLetteringOnMessageExpiration".equals(fieldName)) {
                    deserializedSBQueueProperties.deadLetteringOnMessageExpiration = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("duplicateDetectionHistoryTimeWindow".equals(fieldName)) {
                    deserializedSBQueueProperties.duplicateDetectionHistoryTimeWindow = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("maxDeliveryCount".equals(fieldName)) {
                    deserializedSBQueueProperties.maxDeliveryCount = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSBQueueProperties.status = EntityStatus.fromString(reader.getString());
                    continue;
                }
                if ("enableBatchedOperations".equals(fieldName)) {
                    deserializedSBQueueProperties.enableBatchedOperations = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("autoDeleteOnIdle".equals(fieldName)) {
                    deserializedSBQueueProperties.autoDeleteOnIdle = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("enablePartitioning".equals(fieldName)) {
                    deserializedSBQueueProperties.enablePartitioning = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableExpress".equals(fieldName)) {
                    deserializedSBQueueProperties.enableExpress = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("forwardTo".equals(fieldName)) {
                    deserializedSBQueueProperties.forwardTo = reader.getString();
                    continue;
                }
                if ("forwardDeadLetteredMessagesTo".equals(fieldName)) {
                    deserializedSBQueueProperties.forwardDeadLetteredMessagesTo = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSBQueueProperties;
        });
    }
}

