/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.IndependentChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.models.SBSubscriptionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.ServiceBusSubscription;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.Topic;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.Duration;
import java.time.OffsetDateTime;

class ServiceBusSubscriptionImpl
extends IndependentChildResourceImpl<ServiceBusSubscription, Topic, SBSubscriptionInner, ServiceBusSubscriptionImpl, ServiceBusManager>
implements ServiceBusSubscription,
ServiceBusSubscription.Definition,
ServiceBusSubscription.Update {
    private final String namespaceName;

    ServiceBusSubscriptionImpl(String resourceGroupName, String namespaceName, String topicName, String name, SBSubscriptionInner inner, ServiceBusManager manager) {
        super(name, inner, manager);
        this.namespaceName = namespaceName;
        this.withExistingParentResource(resourceGroupName, topicName);
    }

    @Override
    public OffsetDateTime createdAt() {
        return ((SBSubscriptionInner)this.innerModel()).createdAt();
    }

    @Override
    public OffsetDateTime accessedAt() {
        return ((SBSubscriptionInner)this.innerModel()).accessedAt();
    }

    @Override
    public OffsetDateTime updatedAt() {
        return ((SBSubscriptionInner)this.innerModel()).updatedAt();
    }

    @Override
    public boolean isBatchedOperationsEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((SBSubscriptionInner)this.innerModel()).enableBatchedOperations());
    }

    @Override
    public boolean isDeadLetteringEnabledForExpiredMessages() {
        return ResourceManagerUtils.toPrimitiveBoolean(((SBSubscriptionInner)this.innerModel()).deadLetteringOnMessageExpiration());
    }

    @Override
    public boolean isSessionEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((SBSubscriptionInner)this.innerModel()).requiresSession());
    }

    @Override
    public long lockDurationInSeconds() {
        if (((SBSubscriptionInner)this.innerModel()).lockDuration() == null) {
            return 0L;
        }
        return ((SBSubscriptionInner)this.innerModel()).lockDuration().getSeconds();
    }

    @Override
    public long deleteOnIdleDurationInMinutes() {
        if (((SBSubscriptionInner)this.innerModel()).autoDeleteOnIdle() == null) {
            return 0L;
        }
        return ((SBSubscriptionInner)this.innerModel()).autoDeleteOnIdle().toMinutes();
    }

    @Override
    public Duration defaultMessageTtlDuration() {
        if (((SBSubscriptionInner)this.innerModel()).defaultMessageTimeToLive() == null) {
            return null;
        }
        return ((SBSubscriptionInner)this.innerModel()).defaultMessageTimeToLive();
    }

    @Override
    public int maxDeliveryCountBeforeDeadLetteringMessage() {
        return ResourceManagerUtils.toPrimitiveInt(((SBSubscriptionInner)this.innerModel()).maxDeliveryCount());
    }

    @Override
    public long messageCount() {
        return ResourceManagerUtils.toPrimitiveLong(((SBSubscriptionInner)this.innerModel()).messageCount());
    }

    @Override
    public long activeMessageCount() {
        if (((SBSubscriptionInner)this.innerModel()).countDetails() == null || ((SBSubscriptionInner)this.innerModel()).countDetails().activeMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong(((SBSubscriptionInner)this.innerModel()).countDetails().activeMessageCount());
    }

    @Override
    public long deadLetterMessageCount() {
        if (((SBSubscriptionInner)this.innerModel()).countDetails() == null || ((SBSubscriptionInner)this.innerModel()).countDetails().deadLetterMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong(((SBSubscriptionInner)this.innerModel()).countDetails().deadLetterMessageCount());
    }

    @Override
    public long scheduledMessageCount() {
        if (((SBSubscriptionInner)this.innerModel()).countDetails() == null || ((SBSubscriptionInner)this.innerModel()).countDetails().scheduledMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong(((SBSubscriptionInner)this.innerModel()).countDetails().scheduledMessageCount());
    }

    @Override
    public long transferDeadLetterMessageCount() {
        if (((SBSubscriptionInner)this.innerModel()).countDetails() == null || ((SBSubscriptionInner)this.innerModel()).countDetails().transferDeadLetterMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong(((SBSubscriptionInner)this.innerModel()).countDetails().transferDeadLetterMessageCount());
    }

    @Override
    public long transferMessageCount() {
        if (((SBSubscriptionInner)this.innerModel()).countDetails() == null || ((SBSubscriptionInner)this.innerModel()).countDetails().transferMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong(((SBSubscriptionInner)this.innerModel()).countDetails().transferMessageCount());
    }

    @Override
    public EntityStatus status() {
        return ((SBSubscriptionInner)this.innerModel()).status();
    }

    @Override
    public boolean isDeadLetteringEnabledForFilterEvaluationFailedMessages() {
        return ResourceManagerUtils.toPrimitiveBoolean(((SBSubscriptionInner)this.innerModel()).deadLetteringOnFilterEvaluationExceptions());
    }

    @Override
    public ServiceBusSubscriptionImpl withDeleteOnIdleDurationInMinutes(int durationInMinutes) {
        ((SBSubscriptionInner)this.innerModel()).withAutoDeleteOnIdle(Duration.ofMinutes(durationInMinutes));
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageLockDurationInSeconds(int durationInSeconds) {
        ((SBSubscriptionInner)this.innerModel()).withLockDuration(Duration.ofSeconds(durationInSeconds));
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withDefaultMessageTTL(Duration ttl) {
        ((SBSubscriptionInner)this.innerModel()).withDefaultMessageTimeToLive(ttl);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withSession() {
        ((SBSubscriptionInner)this.innerModel()).withRequiresSession(true);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withoutSession() {
        ((SBSubscriptionInner)this.innerModel()).withRequiresSession(false);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageBatching() {
        ((SBSubscriptionInner)this.innerModel()).withEnableBatchedOperations(true);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withoutMessageBatching() {
        ((SBSubscriptionInner)this.innerModel()).withEnableBatchedOperations(false);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageMovedToDeadLetterSubscriptionOnMaxDeliveryCount(int deliveryCount) {
        ((SBSubscriptionInner)this.innerModel()).withMaxDeliveryCount(deliveryCount);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageMovedToDeadLetterSubscriptionOnFilterEvaluationException() {
        ((SBSubscriptionInner)this.innerModel()).withDeadLetteringOnFilterEvaluationExceptions(true);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withoutMessageMovedToDeadLetterSubscriptionOnFilterEvaluationException() {
        ((SBSubscriptionInner)this.innerModel()).withDeadLetteringOnFilterEvaluationExceptions(false);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withExpiredMessageMovedToDeadLetterSubscription() {
        ((SBSubscriptionInner)this.innerModel()).withDeadLetteringOnMessageExpiration(true);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withoutExpiredMessageMovedToDeadLetterSubscription() {
        ((SBSubscriptionInner)this.innerModel()).withDeadLetteringOnMessageExpiration(false);
        return this;
    }

    @Override
    public ServiceBusSubscriptionImpl withMessageMovedToDeadLetterQueueOnMaxDeliveryCount(int deliveryCount) {
        ((SBSubscriptionInner)this.innerModel()).withMaxDeliveryCount(deliveryCount);
        return this;
    }

    @Override
    protected Mono<SBSubscriptionInner> getInnerAsync() {
        return ((ServiceBusManagementClient)((ServiceBusManager)this.manager()).serviceClient()).getSubscriptions().getAsync(this.resourceGroupName(), this.namespaceName, this.parentName, this.name());
    }

    @Override
    protected Mono<ServiceBusSubscription> createChildResourceAsync() {
        ServiceBusSubscriptionImpl self = this;
        return ((ServiceBusManagementClient)((ServiceBusManager)this.manager()).serviceClient()).getSubscriptions().createOrUpdateAsync(this.resourceGroupName(), this.namespaceName, this.parentName, this.name(), (SBSubscriptionInner)this.innerModel()).map(inner -> {
            this.setInner(inner);
            return self;
        });
    }
}

