/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.IndependentChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.ServiceBusManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.ServiceBusManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.fluent.models.SBTopicInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation.ServiceBusNamespaceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation.ServiceBusSubscriptionsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.implementation.TopicAuthorizationRulesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.ServiceBusSubscription;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.Topic;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.TopicAuthorizationRule;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

class TopicImpl
extends IndependentChildResourceImpl<Topic, ServiceBusNamespaceImpl, SBTopicInner, TopicImpl, ServiceBusManager>
implements Topic,
Topic.Definition,
Topic.Update {
    private List<Creatable<ServiceBusSubscription>> subscriptionsToCreate;
    private List<Creatable<TopicAuthorizationRule>> rulesToCreate;
    private List<String> subscriptionsToDelete;
    private List<String> rulesToDelete;

    TopicImpl(String resourceGroupName, String namespaceName, String name, Region region, SBTopicInner inner, ServiceBusManager manager) {
        super(name, inner, manager);
        this.withExistingParentResource(resourceGroupName, namespaceName);
        this.initChildrenOperationsCache();
    }

    @Override
    public OffsetDateTime createdAt() {
        return ((SBTopicInner)this.innerModel()).createdAt();
    }

    @Override
    public OffsetDateTime accessedAt() {
        return ((SBTopicInner)this.innerModel()).accessedAt();
    }

    @Override
    public OffsetDateTime updatedAt() {
        return ((SBTopicInner)this.innerModel()).updatedAt();
    }

    @Override
    public long maxSizeInMB() {
        return ResourceManagerUtils.toPrimitiveLong(((SBTopicInner)this.innerModel()).maxSizeInMegabytes().longValue());
    }

    @Override
    public long currentSizeInBytes() {
        return ResourceManagerUtils.toPrimitiveLong(((SBTopicInner)this.innerModel()).sizeInBytes());
    }

    @Override
    public boolean isBatchedOperationsEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((SBTopicInner)this.innerModel()).enableBatchedOperations());
    }

    @Override
    public boolean isExpressEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((SBTopicInner)this.innerModel()).enableExpress());
    }

    @Override
    public boolean isPartitioningEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((SBTopicInner)this.innerModel()).enablePartitioning());
    }

    @Override
    public boolean isDuplicateDetectionEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((SBTopicInner)this.innerModel()).requiresDuplicateDetection());
    }

    @Override
    public long deleteOnIdleDurationInMinutes() {
        if (((SBTopicInner)this.innerModel()).autoDeleteOnIdle() == null) {
            return 0L;
        }
        return ((SBTopicInner)this.innerModel()).autoDeleteOnIdle().toMinutes();
    }

    @Override
    public Duration defaultMessageTtlDuration() {
        if (((SBTopicInner)this.innerModel()).defaultMessageTimeToLive() == null) {
            return null;
        }
        return ((SBTopicInner)this.innerModel()).defaultMessageTimeToLive();
    }

    @Override
    public Duration duplicateMessageDetectionHistoryDuration() {
        if (((SBTopicInner)this.innerModel()).duplicateDetectionHistoryTimeWindow() == null) {
            return null;
        }
        return ((SBTopicInner)this.innerModel()).duplicateDetectionHistoryTimeWindow();
    }

    @Override
    public long activeMessageCount() {
        if (((SBTopicInner)this.innerModel()).countDetails() == null || ((SBTopicInner)this.innerModel()).countDetails().activeMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong(((SBTopicInner)this.innerModel()).countDetails().activeMessageCount());
    }

    @Override
    public long deadLetterMessageCount() {
        if (((SBTopicInner)this.innerModel()).countDetails() == null || ((SBTopicInner)this.innerModel()).countDetails().deadLetterMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong(((SBTopicInner)this.innerModel()).countDetails().deadLetterMessageCount());
    }

    @Override
    public long scheduledMessageCount() {
        if (((SBTopicInner)this.innerModel()).countDetails() == null || ((SBTopicInner)this.innerModel()).countDetails().scheduledMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong(((SBTopicInner)this.innerModel()).countDetails().scheduledMessageCount());
    }

    @Override
    public long transferDeadLetterMessageCount() {
        if (((SBTopicInner)this.innerModel()).countDetails() == null || ((SBTopicInner)this.innerModel()).countDetails().transferDeadLetterMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong(((SBTopicInner)this.innerModel()).countDetails().transferDeadLetterMessageCount());
    }

    @Override
    public long transferMessageCount() {
        if (((SBTopicInner)this.innerModel()).countDetails() == null || ((SBTopicInner)this.innerModel()).countDetails().transferMessageCount() == null) {
            return 0L;
        }
        return ResourceManagerUtils.toPrimitiveLong(((SBTopicInner)this.innerModel()).countDetails().transferMessageCount());
    }

    @Override
    public int subscriptionCount() {
        if (((SBTopicInner)this.innerModel()).subscriptionCount() == null) {
            return 0;
        }
        return ResourceManagerUtils.toPrimitiveInt(((SBTopicInner)this.innerModel()).subscriptionCount());
    }

    @Override
    public EntityStatus status() {
        return ((SBTopicInner)this.innerModel()).status();
    }

    @Override
    public ServiceBusSubscriptionsImpl subscriptions() {
        return new ServiceBusSubscriptionsImpl(this.resourceGroupName(), this.parentName, this.name(), this.region(), (ServiceBusManager)this.manager());
    }

    @Override
    public TopicAuthorizationRulesImpl authorizationRules() {
        return new TopicAuthorizationRulesImpl(this.resourceGroupName(), this.parentName, this.name(), this.region(), (ServiceBusManager)this.manager());
    }

    @Override
    public TopicImpl withSizeInMB(long sizeInMB) {
        ((SBTopicInner)this.innerModel()).withMaxSizeInMegabytes((int)sizeInMB);
        return this;
    }

    @Override
    public TopicImpl withPartitioning() {
        ((SBTopicInner)this.innerModel()).withEnablePartitioning(true);
        return this;
    }

    @Override
    public TopicImpl withoutPartitioning() {
        ((SBTopicInner)this.innerModel()).withEnablePartitioning(false);
        return this;
    }

    @Override
    public TopicImpl withDeleteOnIdleDurationInMinutes(int durationInMinutes) {
        ((SBTopicInner)this.innerModel()).withAutoDeleteOnIdle(Duration.ofMinutes(durationInMinutes));
        return this;
    }

    @Override
    public TopicImpl withDefaultMessageTTL(Duration ttl) {
        ((SBTopicInner)this.innerModel()).withDefaultMessageTimeToLive(ttl);
        return this;
    }

    @Override
    public TopicImpl withExpressMessage() {
        ((SBTopicInner)this.innerModel()).withEnableExpress(true);
        return this;
    }

    @Override
    public TopicImpl withoutExpressMessage() {
        ((SBTopicInner)this.innerModel()).withEnableExpress(false);
        return this;
    }

    @Override
    public TopicImpl withMessageBatching() {
        ((SBTopicInner)this.innerModel()).withEnableBatchedOperations(true);
        return this;
    }

    @Override
    public TopicImpl withoutMessageBatching() {
        ((SBTopicInner)this.innerModel()).withEnableBatchedOperations(false);
        return this;
    }

    @Override
    public TopicImpl withDuplicateMessageDetection(Duration duplicateDetectionHistoryDuration) {
        ((SBTopicInner)this.innerModel()).withRequiresDuplicateDetection(true);
        ((SBTopicInner)this.innerModel()).withDuplicateDetectionHistoryTimeWindow(duplicateDetectionHistoryDuration);
        return this;
    }

    @Override
    public TopicImpl withDuplicateMessageDetectionHistoryDuration(Duration duration) {
        ((SBTopicInner)this.innerModel()).withDuplicateDetectionHistoryTimeWindow(duration);
        return this;
    }

    @Override
    public TopicImpl withoutDuplicateMessageDetection() {
        ((SBTopicInner)this.innerModel()).withRequiresDuplicateDetection(false);
        return this;
    }

    @Override
    public TopicImpl withNewSendRule(String name) {
        this.rulesToCreate.add((Creatable<TopicAuthorizationRule>)this.authorizationRules().define(name).withSendingEnabled());
        return this;
    }

    @Override
    public TopicImpl withNewListenRule(String name) {
        this.rulesToCreate.add((Creatable<TopicAuthorizationRule>)this.authorizationRules().define(name).withListeningEnabled());
        return this;
    }

    @Override
    public TopicImpl withNewManageRule(String name) {
        this.rulesToCreate.add((Creatable<TopicAuthorizationRule>)this.authorizationRules().define(name).withManagementEnabled());
        return this;
    }

    @Override
    public TopicImpl withoutAuthorizationRule(String name) {
        this.rulesToDelete.add(name);
        return this;
    }

    @Override
    public TopicImpl withNewSubscription(String name) {
        this.subscriptionsToCreate.add(this.subscriptions().define(name));
        return this;
    }

    @Override
    public TopicImpl withoutSubscription(String name) {
        this.subscriptionsToDelete.add(name);
        return this;
    }

    @Override
    protected Mono<SBTopicInner> getInnerAsync() {
        return ((ServiceBusManagementClient)((ServiceBusManager)this.manager()).serviceClient()).getTopics().getAsync(this.resourceGroupName(), this.parentName, this.name());
    }

    @Override
    protected Mono<Topic> createChildResourceAsync() {
        Mono<SBTopicInner> createTask = ((ServiceBusManagementClient)((ServiceBusManager)this.manager()).serviceClient()).getTopics().createOrUpdateAsync(this.resourceGroupName(), this.parentName, this.name(), (SBTopicInner)this.innerModel()).map(inner -> {
            this.setInner(inner);
            return inner;
        });
        Flux<Void> childOperationTasks = this.submitChildrenOperationsAsync();
        TopicImpl self = this;
        return Flux.concat(createTask, childOperationTasks).doOnTerminate(() -> this.initChildrenOperationsCache()).then(Mono.just(self));
    }

    private void initChildrenOperationsCache() {
        this.subscriptionsToCreate = new ArrayList<Creatable<ServiceBusSubscription>>();
        this.rulesToCreate = new ArrayList<Creatable<TopicAuthorizationRule>>();
        this.subscriptionsToDelete = new ArrayList<String>();
        this.rulesToDelete = new ArrayList<String>();
    }

    private Flux<Void> submitChildrenOperationsAsync() {
        Flux<Object> subscriptionsCreateStream = Flux.empty();
        if (this.subscriptionsToCreate.size() > 0) {
            subscriptionsCreateStream = this.subscriptions().createAsync(this.subscriptionsToCreate).then().flux();
        }
        Flux<Object> rulesCreateStream = Flux.empty();
        if (this.rulesToCreate.size() > 0) {
            rulesCreateStream = this.authorizationRules().createAsync(this.rulesToCreate).then().flux();
        }
        Flux<Object> subscriptionsDeleteStream = Flux.empty();
        if (this.subscriptionsToDelete.size() > 0) {
            subscriptionsDeleteStream = this.subscriptions().deleteByNameAsync(this.subscriptionsToDelete);
        }
        Flux<Object> rulesDeleteStream = Flux.empty();
        if (this.rulesToDelete.size() > 0) {
            rulesDeleteStream = this.authorizationRules().deleteByNameAsync(this.rulesToDelete);
        }
        return Flux.mergeDelayError(32, subscriptionsCreateStream, rulesCreateStream, subscriptionsDeleteStream, rulesDeleteStream);
    }
}

