/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.SkuName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.servicebus.models.SkuTier;
import java.io.IOException;

public final class SBSku
implements JsonSerializable<SBSku> {
    private SkuName name;
    private SkuTier tier;
    private Integer capacity;
    private static final ClientLogger LOGGER = new ClientLogger(SBSku.class);

    public SkuName name() {
        return this.name;
    }

    public SBSku withName(SkuName name) {
        this.name = name;
        return this;
    }

    public SkuTier tier() {
        return this.tier;
    }

    public SBSku withTier(SkuTier tier) {
        this.tier = tier;
        return this;
    }

    public Integer capacity() {
        return this.capacity;
    }

    public SBSku withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model SBSku"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("tier", this.tier == null ? null : this.tier.toString());
        jsonWriter.writeNumberField("capacity", this.capacity);
        return jsonWriter.writeEndObject();
    }

    public static SBSku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SBSku deserializedSBSku = new SBSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSBSku.name = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedSBSku.tier = SkuTier.fromString(reader.getString());
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedSBSku.capacity = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSBSku;
        });
    }
}

