/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.RecommendedActionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.AdvisorStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.AutoExecuteStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.AutoExecuteStatusInheritedFrom;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class AdvisorProperties
implements JsonSerializable<AdvisorProperties> {
    private AdvisorStatus advisorStatus;
    private AutoExecuteStatus autoExecuteStatus;
    private AutoExecuteStatusInheritedFrom autoExecuteStatusInheritedFrom;
    private String recommendationsStatus;
    private OffsetDateTime lastChecked;
    private List<RecommendedActionInner> recommendedActions;
    private static final ClientLogger LOGGER = new ClientLogger(AdvisorProperties.class);

    public AdvisorStatus advisorStatus() {
        return this.advisorStatus;
    }

    public AutoExecuteStatus autoExecuteStatus() {
        return this.autoExecuteStatus;
    }

    public AdvisorProperties withAutoExecuteStatus(AutoExecuteStatus autoExecuteStatus) {
        this.autoExecuteStatus = autoExecuteStatus;
        return this;
    }

    public AutoExecuteStatusInheritedFrom autoExecuteStatusInheritedFrom() {
        return this.autoExecuteStatusInheritedFrom;
    }

    public String recommendationsStatus() {
        return this.recommendationsStatus;
    }

    public OffsetDateTime lastChecked() {
        return this.lastChecked;
    }

    public List<RecommendedActionInner> recommendedActions() {
        return this.recommendedActions;
    }

    public void validate() {
        if (this.autoExecuteStatus() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property autoExecuteStatus in model AdvisorProperties"));
        }
        if (this.recommendedActions() != null) {
            this.recommendedActions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("autoExecuteStatus", this.autoExecuteStatus == null ? null : this.autoExecuteStatus.toString());
        return jsonWriter.writeEndObject();
    }

    public static AdvisorProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AdvisorProperties deserializedAdvisorProperties = new AdvisorProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("autoExecuteStatus".equals(fieldName)) {
                    deserializedAdvisorProperties.autoExecuteStatus = AutoExecuteStatus.fromString(reader.getString());
                    continue;
                }
                if ("advisorStatus".equals(fieldName)) {
                    deserializedAdvisorProperties.advisorStatus = AdvisorStatus.fromString(reader.getString());
                    continue;
                }
                if ("autoExecuteStatusInheritedFrom".equals(fieldName)) {
                    deserializedAdvisorProperties.autoExecuteStatusInheritedFrom = AutoExecuteStatusInheritedFrom.fromString(reader.getString());
                    continue;
                }
                if ("recommendationsStatus".equals(fieldName)) {
                    deserializedAdvisorProperties.recommendationsStatus = reader.getString();
                    continue;
                }
                if ("lastChecked".equals(fieldName)) {
                    deserializedAdvisorProperties.lastChecked = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("recommendedActions".equals(fieldName)) {
                    List<RecommendedActionInner> recommendedActions = reader.readArray(reader1 -> RecommendedActionInner.fromJson(reader1));
                    deserializedAdvisorProperties.recommendedActions = recommendedActions;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAdvisorProperties;
        });
    }
}

