/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SecurityAlertPolicyState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class SecurityAlertsPolicyProperties
implements JsonSerializable<SecurityAlertsPolicyProperties> {
    private SecurityAlertPolicyState state;
    private List<String> disabledAlerts;
    private List<String> emailAddresses;
    private Boolean emailAccountAdmins;
    private String storageEndpoint;
    private String storageAccountAccessKey;
    private Integer retentionDays;
    private OffsetDateTime creationTime;
    private static final ClientLogger LOGGER = new ClientLogger(SecurityAlertsPolicyProperties.class);

    public SecurityAlertPolicyState state() {
        return this.state;
    }

    public SecurityAlertsPolicyProperties withState(SecurityAlertPolicyState state) {
        this.state = state;
        return this;
    }

    public List<String> disabledAlerts() {
        return this.disabledAlerts;
    }

    public SecurityAlertsPolicyProperties withDisabledAlerts(List<String> disabledAlerts) {
        this.disabledAlerts = disabledAlerts;
        return this;
    }

    public List<String> emailAddresses() {
        return this.emailAddresses;
    }

    public SecurityAlertsPolicyProperties withEmailAddresses(List<String> emailAddresses) {
        this.emailAddresses = emailAddresses;
        return this;
    }

    public Boolean emailAccountAdmins() {
        return this.emailAccountAdmins;
    }

    public SecurityAlertsPolicyProperties withEmailAccountAdmins(Boolean emailAccountAdmins) {
        this.emailAccountAdmins = emailAccountAdmins;
        return this;
    }

    public String storageEndpoint() {
        return this.storageEndpoint;
    }

    public SecurityAlertsPolicyProperties withStorageEndpoint(String storageEndpoint) {
        this.storageEndpoint = storageEndpoint;
        return this;
    }

    public String storageAccountAccessKey() {
        return this.storageAccountAccessKey;
    }

    public SecurityAlertsPolicyProperties withStorageAccountAccessKey(String storageAccountAccessKey) {
        this.storageAccountAccessKey = storageAccountAccessKey;
        return this;
    }

    public Integer retentionDays() {
        return this.retentionDays;
    }

    public SecurityAlertsPolicyProperties withRetentionDays(Integer retentionDays) {
        this.retentionDays = retentionDays;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public void validate() {
        if (this.state() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property state in model SecurityAlertsPolicyProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeArrayField("disabledAlerts", this.disabledAlerts, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("emailAddresses", this.emailAddresses, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeBooleanField("emailAccountAdmins", this.emailAccountAdmins);
        jsonWriter.writeStringField("storageEndpoint", this.storageEndpoint);
        jsonWriter.writeStringField("storageAccountAccessKey", this.storageAccountAccessKey);
        jsonWriter.writeNumberField("retentionDays", this.retentionDays);
        return jsonWriter.writeEndObject();
    }

    public static SecurityAlertsPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityAlertsPolicyProperties deserializedSecurityAlertsPolicyProperties = new SecurityAlertsPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedSecurityAlertsPolicyProperties.state = SecurityAlertPolicyState.fromString(reader.getString());
                    continue;
                }
                if ("disabledAlerts".equals(fieldName)) {
                    List<String> disabledAlerts = reader.readArray(reader1 -> reader1.getString());
                    deserializedSecurityAlertsPolicyProperties.disabledAlerts = disabledAlerts;
                    continue;
                }
                if ("emailAddresses".equals(fieldName)) {
                    List<String> emailAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedSecurityAlertsPolicyProperties.emailAddresses = emailAddresses;
                    continue;
                }
                if ("emailAccountAdmins".equals(fieldName)) {
                    deserializedSecurityAlertsPolicyProperties.emailAccountAdmins = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("storageEndpoint".equals(fieldName)) {
                    deserializedSecurityAlertsPolicyProperties.storageEndpoint = reader.getString();
                    continue;
                }
                if ("storageAccountAccessKey".equals(fieldName)) {
                    deserializedSecurityAlertsPolicyProperties.storageAccountAccessKey = reader.getString();
                    continue;
                }
                if ("retentionDays".equals(fieldName)) {
                    deserializedSecurityAlertsPolicyProperties.retentionDays = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedSecurityAlertsPolicyProperties.creationTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityAlertsPolicyProperties;
        });
    }
}

