/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.BlobAuditingPolicyState;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public final class ServerDevOpsAuditSettingsProperties
implements JsonSerializable<ServerDevOpsAuditSettingsProperties> {
    private Boolean isAzureMonitorTargetEnabled;
    private BlobAuditingPolicyState state;
    private String storageEndpoint;
    private String storageAccountAccessKey;
    private UUID storageAccountSubscriptionId;
    private static final ClientLogger LOGGER = new ClientLogger(ServerDevOpsAuditSettingsProperties.class);

    public Boolean isAzureMonitorTargetEnabled() {
        return this.isAzureMonitorTargetEnabled;
    }

    public ServerDevOpsAuditSettingsProperties withIsAzureMonitorTargetEnabled(Boolean isAzureMonitorTargetEnabled) {
        this.isAzureMonitorTargetEnabled = isAzureMonitorTargetEnabled;
        return this;
    }

    public BlobAuditingPolicyState state() {
        return this.state;
    }

    public ServerDevOpsAuditSettingsProperties withState(BlobAuditingPolicyState state) {
        this.state = state;
        return this;
    }

    public String storageEndpoint() {
        return this.storageEndpoint;
    }

    public ServerDevOpsAuditSettingsProperties withStorageEndpoint(String storageEndpoint) {
        this.storageEndpoint = storageEndpoint;
        return this;
    }

    public String storageAccountAccessKey() {
        return this.storageAccountAccessKey;
    }

    public ServerDevOpsAuditSettingsProperties withStorageAccountAccessKey(String storageAccountAccessKey) {
        this.storageAccountAccessKey = storageAccountAccessKey;
        return this;
    }

    public UUID storageAccountSubscriptionId() {
        return this.storageAccountSubscriptionId;
    }

    public ServerDevOpsAuditSettingsProperties withStorageAccountSubscriptionId(UUID storageAccountSubscriptionId) {
        this.storageAccountSubscriptionId = storageAccountSubscriptionId;
        return this;
    }

    public void validate() {
        if (this.state() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property state in model ServerDevOpsAuditSettingsProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeBooleanField("isAzureMonitorTargetEnabled", this.isAzureMonitorTargetEnabled);
        jsonWriter.writeStringField("storageEndpoint", this.storageEndpoint);
        jsonWriter.writeStringField("storageAccountAccessKey", this.storageAccountAccessKey);
        jsonWriter.writeStringField("storageAccountSubscriptionId", Objects.toString(this.storageAccountSubscriptionId, null));
        return jsonWriter.writeEndObject();
    }

    public static ServerDevOpsAuditSettingsProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerDevOpsAuditSettingsProperties deserializedServerDevOpsAuditSettingsProperties = new ServerDevOpsAuditSettingsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedServerDevOpsAuditSettingsProperties.state = BlobAuditingPolicyState.fromString(reader.getString());
                    continue;
                }
                if ("isAzureMonitorTargetEnabled".equals(fieldName)) {
                    deserializedServerDevOpsAuditSettingsProperties.isAzureMonitorTargetEnabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("storageEndpoint".equals(fieldName)) {
                    deserializedServerDevOpsAuditSettingsProperties.storageEndpoint = reader.getString();
                    continue;
                }
                if ("storageAccountAccessKey".equals(fieldName)) {
                    deserializedServerDevOpsAuditSettingsProperties.storageAccountAccessKey = reader.getString();
                    continue;
                }
                if ("storageAccountSubscriptionId".equals(fieldName)) {
                    deserializedServerDevOpsAuditSettingsProperties.storageAccountSubscriptionId = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerDevOpsAuditSettingsProperties;
        });
    }
}

