/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SyncConflictResolutionPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SyncGroupSchema;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SyncGroupState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SyncGroupProperties
implements JsonSerializable<SyncGroupProperties> {
    private Integer interval;
    private OffsetDateTime lastSyncTime;
    private SyncConflictResolutionPolicy conflictResolutionPolicy;
    private String syncDatabaseId;
    private String hubDatabaseUsername;
    private String hubDatabasePassword;
    private SyncGroupState syncState;
    private SyncGroupSchema schema;
    private Boolean enableConflictLogging;
    private Integer conflictLoggingRetentionInDays;
    private Boolean usePrivateLinkConnection;
    private String privateEndpointName;

    public Integer interval() {
        return this.interval;
    }

    public SyncGroupProperties withInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    public OffsetDateTime lastSyncTime() {
        return this.lastSyncTime;
    }

    public SyncConflictResolutionPolicy conflictResolutionPolicy() {
        return this.conflictResolutionPolicy;
    }

    public SyncGroupProperties withConflictResolutionPolicy(SyncConflictResolutionPolicy conflictResolutionPolicy) {
        this.conflictResolutionPolicy = conflictResolutionPolicy;
        return this;
    }

    public String syncDatabaseId() {
        return this.syncDatabaseId;
    }

    public SyncGroupProperties withSyncDatabaseId(String syncDatabaseId) {
        this.syncDatabaseId = syncDatabaseId;
        return this;
    }

    public String hubDatabaseUsername() {
        return this.hubDatabaseUsername;
    }

    public SyncGroupProperties withHubDatabaseUsername(String hubDatabaseUsername) {
        this.hubDatabaseUsername = hubDatabaseUsername;
        return this;
    }

    public String hubDatabasePassword() {
        return this.hubDatabasePassword;
    }

    public SyncGroupProperties withHubDatabasePassword(String hubDatabasePassword) {
        this.hubDatabasePassword = hubDatabasePassword;
        return this;
    }

    public SyncGroupState syncState() {
        return this.syncState;
    }

    public SyncGroupSchema schema() {
        return this.schema;
    }

    public SyncGroupProperties withSchema(SyncGroupSchema schema) {
        this.schema = schema;
        return this;
    }

    public Boolean enableConflictLogging() {
        return this.enableConflictLogging;
    }

    public SyncGroupProperties withEnableConflictLogging(Boolean enableConflictLogging) {
        this.enableConflictLogging = enableConflictLogging;
        return this;
    }

    public Integer conflictLoggingRetentionInDays() {
        return this.conflictLoggingRetentionInDays;
    }

    public SyncGroupProperties withConflictLoggingRetentionInDays(Integer conflictLoggingRetentionInDays) {
        this.conflictLoggingRetentionInDays = conflictLoggingRetentionInDays;
        return this;
    }

    public Boolean usePrivateLinkConnection() {
        return this.usePrivateLinkConnection;
    }

    public SyncGroupProperties withUsePrivateLinkConnection(Boolean usePrivateLinkConnection) {
        this.usePrivateLinkConnection = usePrivateLinkConnection;
        return this;
    }

    public String privateEndpointName() {
        return this.privateEndpointName;
    }

    public void validate() {
        if (this.schema() != null) {
            this.schema().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("interval", this.interval);
        jsonWriter.writeStringField("conflictResolutionPolicy", this.conflictResolutionPolicy == null ? null : this.conflictResolutionPolicy.toString());
        jsonWriter.writeStringField("syncDatabaseId", this.syncDatabaseId);
        jsonWriter.writeStringField("hubDatabaseUserName", this.hubDatabaseUsername);
        jsonWriter.writeStringField("hubDatabasePassword", this.hubDatabasePassword);
        jsonWriter.writeJsonField("schema", this.schema);
        jsonWriter.writeBooleanField("enableConflictLogging", this.enableConflictLogging);
        jsonWriter.writeNumberField("conflictLoggingRetentionInDays", this.conflictLoggingRetentionInDays);
        jsonWriter.writeBooleanField("usePrivateLinkConnection", this.usePrivateLinkConnection);
        return jsonWriter.writeEndObject();
    }

    public static SyncGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SyncGroupProperties deserializedSyncGroupProperties = new SyncGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("interval".equals(fieldName)) {
                    deserializedSyncGroupProperties.interval = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("lastSyncTime".equals(fieldName)) {
                    deserializedSyncGroupProperties.lastSyncTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("conflictResolutionPolicy".equals(fieldName)) {
                    deserializedSyncGroupProperties.conflictResolutionPolicy = SyncConflictResolutionPolicy.fromString(reader.getString());
                    continue;
                }
                if ("syncDatabaseId".equals(fieldName)) {
                    deserializedSyncGroupProperties.syncDatabaseId = reader.getString();
                    continue;
                }
                if ("hubDatabaseUserName".equals(fieldName)) {
                    deserializedSyncGroupProperties.hubDatabaseUsername = reader.getString();
                    continue;
                }
                if ("hubDatabasePassword".equals(fieldName)) {
                    deserializedSyncGroupProperties.hubDatabasePassword = reader.getString();
                    continue;
                }
                if ("syncState".equals(fieldName)) {
                    deserializedSyncGroupProperties.syncState = SyncGroupState.fromString(reader.getString());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedSyncGroupProperties.schema = SyncGroupSchema.fromJson(reader);
                    continue;
                }
                if ("enableConflictLogging".equals(fieldName)) {
                    deserializedSyncGroupProperties.enableConflictLogging = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("conflictLoggingRetentionInDays".equals(fieldName)) {
                    deserializedSyncGroupProperties.conflictLoggingRetentionInDays = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("usePrivateLinkConnection".equals(fieldName)) {
                    deserializedSyncGroupProperties.usePrivateLinkConnection = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("privateEndpointName".equals(fieldName)) {
                    deserializedSyncGroupProperties.privateEndpointName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSyncGroupProperties;
        });
    }
}

