/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.QueryStatisticsProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.QueryTimeGrainType;
import java.io.IOException;
import java.util.List;

public final class TopQueriesInner
implements JsonSerializable<TopQueriesInner> {
    private Integer numberOfQueries;
    private String aggregationFunction;
    private String observationMetric;
    private QueryTimeGrainType intervalType;
    private String startTime;
    private String endTime;
    private List<QueryStatisticsProperties> queries;

    public Integer numberOfQueries() {
        return this.numberOfQueries;
    }

    public String aggregationFunction() {
        return this.aggregationFunction;
    }

    public String observationMetric() {
        return this.observationMetric;
    }

    public QueryTimeGrainType intervalType() {
        return this.intervalType;
    }

    public String startTime() {
        return this.startTime;
    }

    public String endTime() {
        return this.endTime;
    }

    public List<QueryStatisticsProperties> queries() {
        return this.queries;
    }

    public TopQueriesInner withQueries(List<QueryStatisticsProperties> queries) {
        this.queries = queries;
        return this;
    }

    public void validate() {
        if (this.queries() != null) {
            this.queries().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("queries", this.queries, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static TopQueriesInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TopQueriesInner deserializedTopQueriesInner = new TopQueriesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("numberOfQueries".equals(fieldName)) {
                    deserializedTopQueriesInner.numberOfQueries = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("aggregationFunction".equals(fieldName)) {
                    deserializedTopQueriesInner.aggregationFunction = reader.getString();
                    continue;
                }
                if ("observationMetric".equals(fieldName)) {
                    deserializedTopQueriesInner.observationMetric = reader.getString();
                    continue;
                }
                if ("intervalType".equals(fieldName)) {
                    deserializedTopQueriesInner.intervalType = QueryTimeGrainType.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedTopQueriesInner.startTime = reader.getString();
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedTopQueriesInner.endTime = reader.getString();
                    continue;
                }
                if ("queries".equals(fieldName)) {
                    List<QueryStatisticsProperties> queries = reader.readArray(reader1 -> QueryStatisticsProperties.fromJson(reader1));
                    deserializedTopQueriesInner.queries = queries;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTopQueriesInner;
        });
    }
}

