/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.DatabaseVulnerabilityAssessmentsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.DatabaseVulnerabilityAssessmentInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.DatabaseVulnerabilityAssessmentListResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.VulnerabilityAssessmentName;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class DatabaseVulnerabilityAssessmentsClientImpl
implements DatabaseVulnerabilityAssessmentsClient {
    private final DatabaseVulnerabilityAssessmentsService service;
    private final SqlManagementClientImpl client;

    DatabaseVulnerabilityAssessmentsClientImpl(SqlManagementClientImpl client) {
        this.service = RestProxy.create(DatabaseVulnerabilityAssessmentsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseVulnerabilityAssessmentInner>> listByDatabaseSinglePageAsync(String resourceGroupName, String serverName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDatabase(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DatabaseVulnerabilityAssessmentInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseVulnerabilityAssessmentListResult)res.getValue()).value(), ((DatabaseVulnerabilityAssessmentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseVulnerabilityAssessmentInner>> listByDatabaseSinglePageAsync(String resourceGroupName, String serverName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByDatabase(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, DatabaseVulnerabilityAssessmentInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseVulnerabilityAssessmentListResult)res.getValue()).value(), ((DatabaseVulnerabilityAssessmentListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DatabaseVulnerabilityAssessmentInner> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName) {
        return new PagedFlux<DatabaseVulnerabilityAssessmentInner>(() -> this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName), nextLink -> this.listByDatabaseNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DatabaseVulnerabilityAssessmentInner> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, Context context) {
        return new PagedFlux<DatabaseVulnerabilityAssessmentInner>(() -> this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName, context), nextLink -> this.listByDatabaseNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DatabaseVulnerabilityAssessmentInner> listByDatabase(String resourceGroupName, String serverName, String databaseName) {
        return new PagedIterable<DatabaseVulnerabilityAssessmentInner>(this.listByDatabaseAsync(resourceGroupName, serverName, databaseName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DatabaseVulnerabilityAssessmentInner> listByDatabase(String resourceGroupName, String serverName, String databaseName, Context context) {
        return new PagedIterable<DatabaseVulnerabilityAssessmentInner>(this.listByDatabaseAsync(resourceGroupName, serverName, databaseName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatabaseVulnerabilityAssessmentInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DatabaseVulnerabilityAssessmentInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatabaseVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        return this.getWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName).flatMap(res -> Mono.justOrEmpty((DatabaseVulnerabilityAssessmentInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatabaseVulnerabilityAssessmentInner> getWithResponse(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        return this.getWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseVulnerabilityAssessmentInner get(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        return this.getWithResponse(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatabaseVulnerabilityAssessmentInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, DatabaseVulnerabilityAssessmentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DatabaseVulnerabilityAssessmentInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, DatabaseVulnerabilityAssessmentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatabaseVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, DatabaseVulnerabilityAssessmentInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, parameters).flatMap(res -> Mono.justOrEmpty((DatabaseVulnerabilityAssessmentInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatabaseVulnerabilityAssessmentInner> createOrUpdateWithResponse(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, DatabaseVulnerabilityAssessmentInner parameters, Context context) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseVulnerabilityAssessmentInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, DatabaseVulnerabilityAssessmentInner parameters) {
        return this.createOrUpdateWithResponse(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, parameters, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        return this.deleteWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        return this.deleteWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        this.deleteWithResponse(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseVulnerabilityAssessmentInner>> listByDatabaseNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDatabaseNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DatabaseVulnerabilityAssessmentInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseVulnerabilityAssessmentListResult)res.getValue()).value(), ((DatabaseVulnerabilityAssessmentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseVulnerabilityAssessmentInner>> listByDatabaseNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByDatabaseNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, DatabaseVulnerabilityAssessmentInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseVulnerabilityAssessmentListResult)res.getValue()).value(), ((DatabaseVulnerabilityAssessmentListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientD")
    public static interface DatabaseVulnerabilityAssessmentsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseVulnerabilityAssessmentListResult>> listByDatabase(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseVulnerabilityAssessmentInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseVulnerabilityAssessmentInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") DatabaseVulnerabilityAssessmentInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseVulnerabilityAssessmentListResult>> listByDatabaseNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

