/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.SqlServerManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.DatabaseSecurityAlertPolicyInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlDatabaseImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SecurityAlertPolicyName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SecurityAlertPolicyState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlDatabase;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlDatabaseThreatDetectionPolicy;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SqlDatabaseThreatDetectionPolicyImpl
extends ExternalChildResourceImpl<SqlDatabaseThreatDetectionPolicy, DatabaseSecurityAlertPolicyInner, SqlDatabaseImpl, SqlDatabase>
implements SqlDatabaseThreatDetectionPolicy,
SqlDatabaseThreatDetectionPolicy.SqlDatabaseThreatDetectionPolicyDefinition,
SqlDatabaseThreatDetectionPolicy.Update {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    private String policyName;

    protected SqlDatabaseThreatDetectionPolicyImpl(String name, SqlDatabaseImpl parent, DatabaseSecurityAlertPolicyInner innerObject, SqlServerManager sqlServerManager) {
        super(name, parent, innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.sqlServerName();
        this.policyName = name;
    }

    @Override
    public String name() {
        return ((DatabaseSecurityAlertPolicyInner)this.innerModel()).name();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String id() {
        return ((DatabaseSecurityAlertPolicyInner)this.innerModel()).id();
    }

    @Override
    public Region region() {
        return Region.fromName(((SqlDatabaseImpl)this.parent()).regionName());
    }

    @Override
    public String kind() {
        return ((SqlServerImpl)((SqlDatabaseImpl)this.parent()).parent()).kind();
    }

    @Override
    public SecurityAlertPolicyState currentState() {
        return ((DatabaseSecurityAlertPolicyInner)this.innerModel()).state() == null ? null : SecurityAlertPolicyState.fromString(((DatabaseSecurityAlertPolicyInner)this.innerModel()).state().toString());
    }

    @Override
    public String disabledAlerts() {
        List<String> disabledAlerts = ((DatabaseSecurityAlertPolicyInner)this.innerModel()).disabledAlerts();
        if (disabledAlerts == null) {
            return null;
        }
        return String.join((CharSequence)";", disabledAlerts);
    }

    @Override
    public List<String> disabledAlertList() {
        return CoreUtils.isNullOrEmpty(((DatabaseSecurityAlertPolicyInner)this.innerModel()).disabledAlerts()) ? Collections.emptyList() : ((DatabaseSecurityAlertPolicyInner)this.innerModel()).disabledAlerts();
    }

    @Override
    public String emailAddresses() {
        List<String> emailAddresses = ((DatabaseSecurityAlertPolicyInner)this.innerModel()).emailAddresses();
        if (emailAddresses == null) {
            return null;
        }
        return String.join((CharSequence)";", emailAddresses);
    }

    @Override
    public List<String> emailAddressList() {
        return CoreUtils.isNullOrEmpty(((DatabaseSecurityAlertPolicyInner)this.innerModel()).emailAddresses()) ? Collections.emptyList() : ((DatabaseSecurityAlertPolicyInner)this.innerModel()).emailAddresses();
    }

    @Override
    public boolean emailAccountAdmins() {
        return ResourceManagerUtils.toPrimitiveBoolean(((DatabaseSecurityAlertPolicyInner)this.innerModel()).emailAccountAdmins());
    }

    @Override
    public String storageEndpoint() {
        return ((DatabaseSecurityAlertPolicyInner)this.innerModel()).storageEndpoint();
    }

    @Override
    public String storageAccountAccessKey() {
        return ((DatabaseSecurityAlertPolicyInner)this.innerModel()).storageAccountAccessKey();
    }

    @Override
    public int retentionDays() {
        return ((DatabaseSecurityAlertPolicyInner)this.innerModel()).retentionDays();
    }

    @Override
    public boolean isDefaultSecurityAlertPolicy() {
        return SecurityAlertPolicyName.DEFAULT.toString().equalsIgnoreCase(this.name());
    }

    @Override
    protected Mono<DatabaseSecurityAlertPolicyInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabaseSecurityAlertPolicies().getAsync(this.resourceGroupName, this.sqlServerName, ((SqlDatabaseImpl)this.parent()).name(), SecurityAlertPolicyName.fromString(this.name()));
    }

    @Override
    public Mono<SqlDatabaseThreatDetectionPolicy> createResourceAsync() {
        SqlDatabaseThreatDetectionPolicyImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabaseSecurityAlertPolicies().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, ((SqlDatabaseImpl)this.parent()).name(), SecurityAlertPolicyName.fromString(this.policyName), (DatabaseSecurityAlertPolicyInner)this.innerModel()).map(databaseSecurityAlertPolicyInner -> {
            self.setInner(databaseSecurityAlertPolicyInner);
            this.policyName = databaseSecurityAlertPolicyInner.name();
            return self;
        });
    }

    @Override
    public Mono<SqlDatabaseThreatDetectionPolicy> updateResourceAsync() {
        return this.createResourceAsync();
    }

    @Override
    public SqlDatabaseThreatDetectionPolicy.Update update() {
        super.prepareUpdate();
        return this;
    }

    @Override
    public Mono<Void> deleteResourceAsync() {
        return null;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withPolicyEnabled() {
        ((DatabaseSecurityAlertPolicyInner)this.innerModel()).withState(SecurityAlertPolicyState.ENABLED);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withPolicyDisabled() {
        ((DatabaseSecurityAlertPolicyInner)this.innerModel()).withState(SecurityAlertPolicyState.DISABLED);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withDefaultSecurityAlertPolicy() {
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withStorageEndpoint(String storageEndpoint) {
        ((DatabaseSecurityAlertPolicyInner)this.innerModel()).withStorageEndpoint(storageEndpoint);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withStorageAccountAccessKey(String storageAccountAccessKey) {
        ((DatabaseSecurityAlertPolicyInner)this.innerModel()).withStorageAccountAccessKey(storageAccountAccessKey);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withAlertsFilter(String alertsFilter) {
        if (alertsFilter != null) {
            ((DatabaseSecurityAlertPolicyInner)this.innerModel()).withDisabledAlerts(Stream.of(alertsFilter.split(Pattern.quote(";"))).collect(Collectors.toList()));
        }
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withAlertsFilter(List<String> alertsFilter) {
        if (alertsFilter != null) {
            ((DatabaseSecurityAlertPolicyInner)this.innerModel()).withDisabledAlerts(alertsFilter);
        }
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withEmailAddresses(String addresses) {
        if (addresses != null) {
            ((DatabaseSecurityAlertPolicyInner)this.innerModel()).withEmailAddresses(Stream.of(addresses.split(Pattern.quote(";"))).collect(Collectors.toList()));
        }
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withEmailAddresses(List<String> addresses) {
        if (addresses != null) {
            ((DatabaseSecurityAlertPolicyInner)this.innerModel()).withEmailAddresses(addresses);
        }
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withRetentionDays(int retentionDays) {
        ((DatabaseSecurityAlertPolicyInner)this.innerModel()).withRetentionDays(retentionDays);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withEmailToAccountAdmins() {
        ((DatabaseSecurityAlertPolicyInner)this.innerModel()).withEmailAccountAdmins(true);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withoutEmailToAccountAdmins() {
        ((DatabaseSecurityAlertPolicyInner)this.innerModel()).withEmailAccountAdmins(false);
        return this;
    }
}

