/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.SqlServerManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.EncryptionProtectorInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.EncryptionProtectorName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ServerKeyType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlEncryptionProtector;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServer;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Objects;

public class SqlEncryptionProtectorImpl
extends ExternalChildResourceImpl<SqlEncryptionProtector, EncryptionProtectorInner, SqlServerImpl, SqlServer>
implements SqlEncryptionProtector,
SqlEncryptionProtector.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    private String serverKeyName;

    SqlEncryptionProtectorImpl(SqlServerImpl parent, EncryptionProtectorInner innerObject, SqlServerManager sqlServerManager) {
        super("", parent, innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
        if (innerObject != null && innerObject.name() != null) {
            this.serverKeyName = innerObject.name();
        }
    }

    SqlEncryptionProtectorImpl(String resourceGroupName, String sqlServerName, EncryptionProtectorInner innerObject, SqlServerManager sqlServerManager) {
        super("", null, innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        if (innerObject != null && innerObject.name() != null) {
            this.serverKeyName = innerObject.name();
        }
    }

    SqlEncryptionProtectorImpl(EncryptionProtectorInner innerObject, SqlServerManager sqlServerManager) {
        super("", null, innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        if (innerObject != null && innerObject.id() != null) {
            if (innerObject.name() != null) {
                this.serverKeyName = innerObject.name();
            }
            try {
                ResourceId resourceId = ResourceId.fromString(innerObject.id());
                this.resourceGroupName = resourceId.resourceGroupName();
                this.sqlServerName = resourceId.parent().name();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public String id() {
        return ((EncryptionProtectorInner)this.innerModel()).id();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.serverKeyName;
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId(((EncryptionProtectorInner)this.innerModel()).id());
    }

    @Override
    public String kind() {
        return ((EncryptionProtectorInner)this.innerModel()).kind();
    }

    @Override
    public Region region() {
        return Region.fromName(((EncryptionProtectorInner)this.innerModel()).location());
    }

    @Override
    public String serverKeyName() {
        return ((EncryptionProtectorInner)this.innerModel()).serverKeyName();
    }

    @Override
    public ServerKeyType serverKeyType() {
        return ((EncryptionProtectorInner)this.innerModel()).serverKeyType();
    }

    @Override
    public String uri() {
        return ((EncryptionProtectorInner)this.innerModel()).uri();
    }

    @Override
    public String thumbprint() {
        return ((EncryptionProtectorInner)this.innerModel()).thumbprint();
    }

    @Override
    public SqlEncryptionProtectorImpl withAzureKeyVaultServerKey(String serverKeyName) {
        ((EncryptionProtectorInner)this.innerModel()).withServerKeyName(serverKeyName);
        ((EncryptionProtectorInner)this.innerModel()).withServerKeyType(ServerKeyType.AZURE_KEY_VAULT);
        return this;
    }

    @Override
    public SqlEncryptionProtectorImpl withServiceManagedServerKey() {
        ((EncryptionProtectorInner)this.innerModel()).withServerKeyName("ServiceManaged");
        ((EncryptionProtectorInner)this.innerModel()).withServerKeyType(ServerKeyType.SERVICE_MANAGED);
        return this;
    }

    @Override
    public Mono<SqlEncryptionProtector> createResourceAsync() {
        SqlEncryptionProtectorImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getEncryptionProtectors().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, EncryptionProtectorName.CURRENT, (EncryptionProtectorInner)this.innerModel()).map(encryptionProtectorInner -> {
            self.setInner(encryptionProtectorInner);
            return self;
        });
    }

    @Override
    public SqlEncryptionProtectorImpl update() {
        return this;
    }

    @Override
    public Mono<SqlEncryptionProtector> updateResourceAsync() {
        return this.createResourceAsync();
    }

    @Override
    public Mono<Void> deleteResourceAsync() {
        throw this.logger.logExceptionAsError(new UnsupportedOperationException("Delete operation not supported"));
    }

    @Override
    protected Mono<EncryptionProtectorInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getEncryptionProtectors().getAsync(this.resourceGroupName, this.sqlServerName, EncryptionProtectorName.CURRENT);
    }
}

