/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.SqlServerManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.ServerKeyInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ServerKeyType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServer;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServerKey;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServerKeyOperations;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.OffsetDateTime;
import java.util.Objects;

public class SqlServerKeyImpl
extends ExternalChildResourceImpl<SqlServerKey, ServerKeyInner, SqlServerImpl, SqlServer>
implements SqlServerKey,
SqlServerKeyOperations.SqlServerKeyOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    private String serverKeyName;

    SqlServerKeyImpl(String name, SqlServerImpl parent, ServerKeyInner innerObject, SqlServerManager sqlServerManager) {
        super(name, parent, innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
        if (innerObject != null && innerObject.name() != null) {
            this.serverKeyName = innerObject.name();
        }
    }

    SqlServerKeyImpl(String resourceGroupName, String sqlServerName, String name, ServerKeyInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        if (innerObject != null && innerObject.name() != null) {
            this.serverKeyName = innerObject.name();
        }
    }

    SqlServerKeyImpl(String name, ServerKeyInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        if (innerObject != null && innerObject.id() != null) {
            if (innerObject.name() != null) {
                this.serverKeyName = innerObject.name();
            }
            try {
                ResourceId resourceId = ResourceId.fromString(innerObject.id());
                this.resourceGroupName = resourceId.resourceGroupName();
                this.sqlServerName = resourceId.parent().name();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public String id() {
        return ((ServerKeyInner)this.innerModel()).id();
    }

    @Override
    public String name() {
        return this.serverKeyName;
    }

    @Override
    public SqlServerKeyImpl withExistingSqlServer(String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        return this;
    }

    @Override
    public SqlServerKeyImpl withExistingSqlServerId(String sqlServerId) {
        Objects.requireNonNull(sqlServerId);
        ResourceId resourceId = ResourceId.fromString(sqlServerId);
        this.resourceGroupName = resourceId.resourceGroupName();
        this.sqlServerName = resourceId.name();
        return this;
    }

    @Override
    public SqlServerKeyImpl withExistingSqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        return this;
    }

    @Override
    public SqlServerKeyImpl withAzureKeyVaultKey(String uri) {
        ((ServerKeyInner)this.innerModel()).withServerKeyType(ServerKeyType.AZURE_KEY_VAULT);
        ((ServerKeyInner)this.innerModel()).withUri(uri);
        String[] items = uri.split("\\/");
        this.serverKeyName = String.format("%s_%s_%s", items[2].split("\\.")[0], items[4], items[5]);
        return this;
    }

    @Override
    public Mono<SqlServerKey> createResourceAsync() {
        SqlServerKeyImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerKeys().createOrUpdateAsync(self.resourceGroupName, self.sqlServerName, self.serverKeyName, (ServerKeyInner)self.innerModel()).map(serverKeyInner -> {
            self.setInner(serverKeyInner);
            return self;
        });
    }

    @Override
    public Mono<SqlServerKey> updateResourceAsync() {
        return this.createResourceAsync();
    }

    @Override
    public Mono<Void> deleteResourceAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerKeys().deleteAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    protected Mono<ServerKeyInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerKeys().getAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId(((ServerKeyInner)this.innerModel()).id());
    }

    @Override
    public String kind() {
        return ((ServerKeyInner)this.innerModel()).kind();
    }

    @Override
    public Region region() {
        return Region.fromName(((ServerKeyInner)this.innerModel()).location());
    }

    @Override
    public ServerKeyType serverKeyType() {
        return ((ServerKeyInner)this.innerModel()).serverKeyType();
    }

    @Override
    public String uri() {
        return ((ServerKeyInner)this.innerModel()).uri();
    }

    @Override
    public String thumbprint() {
        return ((ServerKeyInner)this.innerModel()).thumbprint();
    }

    @Override
    public OffsetDateTime creationDate() {
        return ((ServerKeyInner)this.innerModel()).creationDate();
    }

    @Override
    public void delete() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerKeys().delete(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public Mono<Void> deleteAsync() {
        return this.deleteResourceAsync();
    }
}

