/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.SqlServerManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.SyncFullSchemaPropertiesInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.SyncGroupInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.SyncGroupLogPropertiesInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlDatabaseImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlSyncFullSchemaPropertyImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlSyncGroupLogPropertyImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlSyncMemberOperationsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlDatabase;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlSyncFullSchemaProperty;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlSyncGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlSyncGroupLogProperty;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlSyncGroupOperations;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlSyncMemberOperations;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SyncConflictResolutionPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SyncGroupSchema;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SyncGroupState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SyncGroupsType;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.OffsetDateTime;
import java.util.Objects;

public class SqlSyncGroupImpl
extends ExternalChildResourceImpl<SqlSyncGroup, SyncGroupInner, SqlDatabaseImpl, SqlDatabase>
implements SqlSyncGroup,
SqlSyncGroup.Update,
SqlSyncGroupOperations.SqlSyncGroupOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    private String sqlDatabaseName;
    private SqlSyncMemberOperations.SqlSyncMemberActionsDefinition syncMemberOps;

    SqlSyncGroupImpl(String name, SqlDatabaseImpl parent, SyncGroupInner innerObject, SqlServerManager sqlServerManager) {
        super(name, parent, innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.sqlServerName();
        this.sqlDatabaseName = parent.name();
    }

    SqlSyncGroupImpl(String resourceGroupName, String sqlServerName, String sqlDatabaseName, String name, SyncGroupInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlDatabaseName = sqlDatabaseName;
    }

    SqlSyncGroupImpl(String name, SyncGroupInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        if (innerObject != null && innerObject.id() != null) {
            try {
                ResourceId resourceId = ResourceId.fromString(innerObject.id());
                this.resourceGroupName = resourceId.resourceGroupName();
                this.sqlServerName = resourceId.parent().parent().name();
                this.sqlDatabaseName = resourceId.parent().name();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String id() {
        return ((SyncGroupInner)this.innerModel()).id();
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String sqlDatabaseName() {
        return this.sqlDatabaseName;
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId(((SyncGroupInner)this.innerModel()).id());
    }

    @Override
    public int interval() {
        return ((SyncGroupInner)this.innerModel()).interval();
    }

    @Override
    public OffsetDateTime lastSyncTime() {
        return ((SyncGroupInner)this.innerModel()).lastSyncTime();
    }

    @Override
    public SyncConflictResolutionPolicy conflictResolutionPolicy() {
        return ((SyncGroupInner)this.innerModel()).conflictResolutionPolicy();
    }

    @Override
    public String syncDatabaseId() {
        return ((SyncGroupInner)this.innerModel()).syncDatabaseId();
    }

    @Override
    public String databaseUserName() {
        return ((SyncGroupInner)this.innerModel()).hubDatabaseUsername();
    }

    @Override
    public SyncGroupState syncState() {
        return ((SyncGroupInner)this.innerModel()).syncState();
    }

    @Override
    public SyncGroupSchema schema() {
        return ((SyncGroupInner)this.innerModel()).schema();
    }

    @Override
    public void refreshHubSchema() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().refreshHubSchema(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public Mono<Void> refreshHubSchemaAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().refreshHubSchemaAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public PagedIterable<SqlSyncFullSchemaProperty> listHubSchemas() {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().listHubSchemas(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name()), inner -> new SqlSyncFullSchemaPropertyImpl((SyncFullSchemaPropertiesInner)inner));
    }

    @Override
    public PagedFlux<SqlSyncFullSchemaProperty> listHubSchemasAsync() {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().listHubSchemasAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name()), syncFullSchemaPropertiesInner -> new SqlSyncFullSchemaPropertyImpl((SyncFullSchemaPropertiesInner)syncFullSchemaPropertiesInner));
    }

    @Override
    public PagedIterable<SqlSyncGroupLogProperty> listLogs(String startTime, String endTime, String type) {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().listLogs(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name(), startTime, endTime, SyncGroupsType.fromString(type)), inner -> new SqlSyncGroupLogPropertyImpl((SyncGroupLogPropertiesInner)inner));
    }

    @Override
    public PagedFlux<SqlSyncGroupLogProperty> listLogsAsync(String startTime, String endTime, String type) {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().listLogsAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name(), startTime, endTime, SyncGroupsType.fromString(type)), syncGroupLogPropertiesInner -> new SqlSyncGroupLogPropertyImpl((SyncGroupLogPropertiesInner)syncGroupLogPropertiesInner));
    }

    @Override
    public void triggerSynchronization() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().triggerSync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public Mono<Void> triggerSynchronizationAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().triggerSyncAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public void cancelSynchronization() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().cancelSync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public Mono<Void> cancelSynchronizationAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().cancelSyncAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public SqlSyncGroupImpl withExistingSqlServer(String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        return this;
    }

    @Override
    public SqlSyncGroupImpl withExistingSqlDatabase(SqlDatabase sqlDatabase) {
        this.resourceGroupName = sqlDatabase.resourceGroupName();
        this.sqlServerName = sqlDatabase.sqlServerName();
        this.sqlDatabaseName = sqlDatabase.name();
        return this;
    }

    @Override
    public SqlSyncGroupImpl withExistingDatabaseName(String databaseName) {
        this.sqlDatabaseName = databaseName;
        return this;
    }

    @Override
    public SqlSyncGroupImpl withSyncDatabaseId(String syncDatabaseId) {
        ((SyncGroupInner)this.innerModel()).withSyncDatabaseId(syncDatabaseId);
        return this;
    }

    @Override
    public SqlSyncGroupImpl withDatabaseUserName(String userName) {
        ((SyncGroupInner)this.innerModel()).withHubDatabaseUsername(userName);
        return this;
    }

    @Override
    public SqlSyncGroupImpl withDatabasePassword(String password) {
        ((SyncGroupInner)this.innerModel()).withHubDatabasePassword(password);
        return this;
    }

    @Override
    public SqlSyncGroupImpl withConflictResolutionPolicyHubWins() {
        ((SyncGroupInner)this.innerModel()).withConflictResolutionPolicy(SyncConflictResolutionPolicy.HUB_WIN);
        return this;
    }

    @Override
    public SqlSyncGroupImpl withConflictResolutionPolicyMemberWins() {
        ((SyncGroupInner)this.innerModel()).withConflictResolutionPolicy(SyncConflictResolutionPolicy.MEMBER_WIN);
        return this;
    }

    @Override
    public SqlSyncGroupImpl withInterval(int interval) {
        ((SyncGroupInner)this.innerModel()).withInterval(interval);
        return this;
    }

    @Override
    public SqlSyncGroupImpl withSchema(SyncGroupSchema schema) {
        ((SyncGroupInner)this.innerModel()).withSchema(schema);
        return this;
    }

    @Override
    public SqlSyncGroup.Update update() {
        this.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeUpdated);
        return this;
    }

    @Override
    public Mono<SqlSyncGroup> createResourceAsync() {
        SqlSyncGroupImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name(), (SyncGroupInner)this.innerModel()).map(syncGroupInner -> {
            self.setInner(syncGroupInner);
            return self;
        });
    }

    @Override
    public Mono<SqlSyncGroup> updateResourceAsync() {
        return this.createResourceAsync();
    }

    @Override
    public Mono<Void> deleteResourceAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().deleteAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    protected Mono<SyncGroupInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().getAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public void delete() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().delete(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public Mono<Void> deleteAsync() {
        return this.deleteResourceAsync();
    }

    @Override
    public SqlSyncMemberOperations.SqlSyncMemberActionsDefinition syncMembers() {
        if (this.syncMemberOps == null) {
            this.syncMemberOps = new SqlSyncMemberOperationsImpl(this, this.sqlServerManager);
        }
        return this.syncMemberOps;
    }
}

