/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.JobStepActionSource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.JobStepActionType;
import java.io.IOException;

public final class JobStepAction
implements JsonSerializable<JobStepAction> {
    private JobStepActionType type;
    private JobStepActionSource source;
    private String value;
    private static final ClientLogger LOGGER = new ClientLogger(JobStepAction.class);

    public JobStepActionType type() {
        return this.type;
    }

    public JobStepAction withType(JobStepActionType type) {
        this.type = type;
        return this;
    }

    public JobStepActionSource source() {
        return this.source;
    }

    public JobStepAction withSource(JobStepActionSource source2) {
        this.source = source2;
        return this;
    }

    public String value() {
        return this.value;
    }

    public JobStepAction withValue(String value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property value in model JobStepAction"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("source", this.source == null ? null : this.source.toString());
        return jsonWriter.writeEndObject();
    }

    public static JobStepAction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JobStepAction deserializedJobStepAction = new JobStepAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedJobStepAction.value = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedJobStepAction.type = JobStepActionType.fromString(reader.getString());
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedJobStepAction.source = JobStepActionSource.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobStepAction;
        });
    }
}

