/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.JobTargetGroupMembershipType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.JobTargetType;
import java.io.IOException;

public final class JobTarget
implements JsonSerializable<JobTarget> {
    private JobTargetGroupMembershipType membershipType;
    private JobTargetType type;
    private String serverName;
    private String databaseName;
    private String elasticPoolName;
    private String shardMapName;
    private String refreshCredential;
    private static final ClientLogger LOGGER = new ClientLogger(JobTarget.class);

    public JobTargetGroupMembershipType membershipType() {
        return this.membershipType;
    }

    public JobTarget withMembershipType(JobTargetGroupMembershipType membershipType) {
        this.membershipType = membershipType;
        return this;
    }

    public JobTargetType type() {
        return this.type;
    }

    public JobTarget withType(JobTargetType type) {
        this.type = type;
        return this;
    }

    public String serverName() {
        return this.serverName;
    }

    public JobTarget withServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public JobTarget withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public String elasticPoolName() {
        return this.elasticPoolName;
    }

    public JobTarget withElasticPoolName(String elasticPoolName) {
        this.elasticPoolName = elasticPoolName;
        return this;
    }

    public String shardMapName() {
        return this.shardMapName;
    }

    public JobTarget withShardMapName(String shardMapName) {
        this.shardMapName = shardMapName;
        return this;
    }

    public String refreshCredential() {
        return this.refreshCredential;
    }

    public JobTarget withRefreshCredential(String refreshCredential) {
        this.refreshCredential = refreshCredential;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property type in model JobTarget"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("membershipType", this.membershipType == null ? null : this.membershipType.toString());
        jsonWriter.writeStringField("serverName", this.serverName);
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeStringField("elasticPoolName", this.elasticPoolName);
        jsonWriter.writeStringField("shardMapName", this.shardMapName);
        jsonWriter.writeStringField("refreshCredential", this.refreshCredential);
        return jsonWriter.writeEndObject();
    }

    public static JobTarget fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JobTarget deserializedJobTarget = new JobTarget();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedJobTarget.type = JobTargetType.fromString(reader.getString());
                    continue;
                }
                if ("membershipType".equals(fieldName)) {
                    deserializedJobTarget.membershipType = JobTargetGroupMembershipType.fromString(reader.getString());
                    continue;
                }
                if ("serverName".equals(fieldName)) {
                    deserializedJobTarget.serverName = reader.getString();
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedJobTarget.databaseName = reader.getString();
                    continue;
                }
                if ("elasticPoolName".equals(fieldName)) {
                    deserializedJobTarget.elasticPoolName = reader.getString();
                    continue;
                }
                if ("shardMapName".equals(fieldName)) {
                    deserializedJobTarget.shardMapName = reader.getString();
                    continue;
                }
                if ("refreshCredential".equals(fieldName)) {
                    deserializedJobTarget.refreshCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobTarget;
        });
    }
}

