/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.QueryMetricProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.QueryTimeGrainType;
import java.io.IOException;
import java.util.List;

public final class QueryMetricInterval
implements JsonSerializable<QueryMetricInterval> {
    private String intervalStartTime;
    private QueryTimeGrainType intervalType;
    private Long executionCount;
    private List<QueryMetricProperties> metrics;

    public String intervalStartTime() {
        return this.intervalStartTime;
    }

    public QueryTimeGrainType intervalType() {
        return this.intervalType;
    }

    public Long executionCount() {
        return this.executionCount;
    }

    public List<QueryMetricProperties> metrics() {
        return this.metrics;
    }

    public QueryMetricInterval withMetrics(List<QueryMetricProperties> metrics) {
        this.metrics = metrics;
        return this;
    }

    public void validate() {
        if (this.metrics() != null) {
            this.metrics().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("metrics", this.metrics, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static QueryMetricInterval fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryMetricInterval deserializedQueryMetricInterval = new QueryMetricInterval();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("intervalStartTime".equals(fieldName)) {
                    deserializedQueryMetricInterval.intervalStartTime = reader.getString();
                    continue;
                }
                if ("intervalType".equals(fieldName)) {
                    deserializedQueryMetricInterval.intervalType = QueryTimeGrainType.fromString(reader.getString());
                    continue;
                }
                if ("executionCount".equals(fieldName)) {
                    deserializedQueryMetricInterval.executionCount = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("metrics".equals(fieldName)) {
                    List<QueryMetricProperties> metrics = reader.readArray(reader1 -> QueryMetricProperties.fromJson(reader1));
                    deserializedQueryMetricInterval.metrics = metrics;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueryMetricInterval;
        });
    }
}

