/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.IdentityType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.UserIdentity;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

public final class ResourceIdentity
implements JsonSerializable<ResourceIdentity> {
    private Map<String, UserIdentity> userAssignedIdentities;
    private UUID principalId;
    private IdentityType type;
    private UUID tenantId;

    public Map<String, UserIdentity> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public ResourceIdentity withUserAssignedIdentities(Map<String, UserIdentity> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public UUID principalId() {
        return this.principalId;
    }

    public IdentityType type() {
        return this.type;
    }

    public ResourceIdentity withType(IdentityType type) {
        this.type = type;
        return this;
    }

    public UUID tenantId() {
        return this.tenantId;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResourceIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceIdentity deserializedResourceIdentity = new ResourceIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map<String, UserIdentity> userAssignedIdentities = reader.readMap(reader1 -> UserIdentity.fromJson(reader1));
                    deserializedResourceIdentity.userAssignedIdentities = userAssignedIdentities;
                    continue;
                }
                if ("principalId".equals(fieldName)) {
                    deserializedResourceIdentity.principalId = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedResourceIdentity.type = IdentityType.fromString(reader.getString());
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedResourceIdentity.tenantId = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceIdentity;
        });
    }
}

