/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.CapabilityStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.EditionCapability;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ElasticPoolEditionCapability;
import java.io.IOException;
import java.util.List;

public final class ServerVersionCapability
implements JsonSerializable<ServerVersionCapability> {
    private String name;
    private List<EditionCapability> supportedEditions;
    private List<ElasticPoolEditionCapability> supportedElasticPoolEditions;
    private CapabilityStatus status;
    private String reason;

    public String name() {
        return this.name;
    }

    public List<EditionCapability> supportedEditions() {
        return this.supportedEditions;
    }

    public List<ElasticPoolEditionCapability> supportedElasticPoolEditions() {
        return this.supportedElasticPoolEditions;
    }

    public CapabilityStatus status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public ServerVersionCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public void validate() {
        if (this.supportedEditions() != null) {
            this.supportedEditions().forEach(e -> e.validate());
        }
        if (this.supportedElasticPoolEditions() != null) {
            this.supportedElasticPoolEditions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    public static ServerVersionCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerVersionCapability deserializedServerVersionCapability = new ServerVersionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedServerVersionCapability.name = reader.getString();
                    continue;
                }
                if ("supportedEditions".equals(fieldName)) {
                    List<EditionCapability> supportedEditions = reader.readArray(reader1 -> EditionCapability.fromJson(reader1));
                    deserializedServerVersionCapability.supportedEditions = supportedEditions;
                    continue;
                }
                if ("supportedElasticPoolEditions".equals(fieldName)) {
                    List<ElasticPoolEditionCapability> supportedElasticPoolEditions = reader.readArray(reader1 -> ElasticPoolEditionCapability.fromJson(reader1));
                    deserializedServerVersionCapability.supportedElasticPoolEditions = supportedElasticPoolEditions;
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedServerVersionCapability.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedServerVersionCapability.reason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerVersionCapability;
        });
    }
}

