/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.management.profile.AzureProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.AuthorizationManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.StorageManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation.BlobContainersImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation.BlobServicesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation.ManagementPoliciesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation.StorageAccountsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation.StorageManagementClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation.StorageSkusImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation.UsagesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.BlobContainers;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.BlobServices;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.ManagementPolicies;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.StorageAccounts;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.StorageSkus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.Usages;
import java.util.Objects;

public final class StorageManager
extends Manager<StorageManagementClient> {
    private StorageAccounts storageAccounts;
    private Usages storageUsages;
    private StorageSkus storageSkus;
    private BlobContainers blobContainers;
    private BlobServices blobServices;
    private ManagementPolicies managementPolicies;
    private final AuthorizationManager authorizationManager;

    public AuthorizationManager authorizationManager() {
        return this.authorizationManager;
    }

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static StorageManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return StorageManager.authenticate(HttpPipelineProvider.buildHttpPipeline(credential, profile), profile);
    }

    public static StorageManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new StorageManager(httpPipeline, profile);
    }

    private StorageManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, new StorageManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
        this.authorizationManager = AuthorizationManager.authenticate(httpPipeline, profile);
    }

    public StorageAccounts storageAccounts() {
        if (this.storageAccounts == null) {
            this.storageAccounts = new StorageAccountsImpl(this, this.authorizationManager);
        }
        return this.storageAccounts;
    }

    public Usages usages() {
        if (this.storageUsages == null) {
            this.storageUsages = new UsagesImpl(this);
        }
        return this.storageUsages;
    }

    public StorageSkus storageSkus() {
        if (this.storageSkus == null) {
            this.storageSkus = new StorageSkusImpl(this);
        }
        return this.storageSkus;
    }

    public BlobContainers blobContainers() {
        if (this.blobContainers == null) {
            this.blobContainers = new BlobContainersImpl(this);
        }
        return this.blobContainers;
    }

    public BlobServices blobServices() {
        if (this.blobServices == null) {
            this.blobServices = new BlobServicesImpl(this);
        }
        return this.blobServices;
    }

    public ManagementPolicies managementPolicies() {
        if (this.managementPolicies == null) {
            this.managementPolicies = new ManagementPoliciesImpl(this);
        }
        return this.managementPolicies;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public StorageManager authenticate(TokenCredential credential, AzureProfile profile) {
            return StorageManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public StorageManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

