/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.BlobInventoryPolicySchema;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class BlobInventoryPolicyProperties
implements JsonSerializable<BlobInventoryPolicyProperties> {
    private OffsetDateTime lastModifiedTime;
    private BlobInventoryPolicySchema policy;
    private static final ClientLogger LOGGER = new ClientLogger(BlobInventoryPolicyProperties.class);

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public BlobInventoryPolicySchema policy() {
        return this.policy;
    }

    public BlobInventoryPolicyProperties withPolicy(BlobInventoryPolicySchema policy) {
        this.policy = policy;
        return this;
    }

    public void validate() {
        if (this.policy() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property policy in model BlobInventoryPolicyProperties"));
        }
        this.policy().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("policy", this.policy);
        return jsonWriter.writeEndObject();
    }

    public static BlobInventoryPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BlobInventoryPolicyProperties deserializedBlobInventoryPolicyProperties = new BlobInventoryPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policy".equals(fieldName)) {
                    deserializedBlobInventoryPolicyProperties.policy = BlobInventoryPolicySchema.fromJson(reader);
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedBlobInventoryPolicyProperties.lastModifiedTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBlobInventoryPolicyProperties;
        });
    }
}

