/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.DateTimeRfc1123;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.EnabledProtocols;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.FileSharePropertiesFileSharePaidBursting;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.LeaseDuration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.LeaseState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.LeaseStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.RootSquashType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.ShareAccessTier;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.SignedIdentifier;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class FileShareProperties
implements JsonSerializable<FileShareProperties> {
    private OffsetDateTime lastModifiedTime;
    private Map<String, String> metadata;
    private Integer shareQuota;
    private Integer provisionedIops;
    private Integer provisionedBandwidthMibps;
    private Integer includedBurstIops;
    private Long maxBurstCreditsForIops;
    private DateTimeRfc1123 nextAllowedQuotaDowngradeTime;
    private DateTimeRfc1123 nextAllowedProvisionedIopsDowngradeTime;
    private DateTimeRfc1123 nextAllowedProvisionedBandwidthDowngradeTime;
    private EnabledProtocols enabledProtocols;
    private RootSquashType rootSquash;
    private String version;
    private Boolean deleted;
    private OffsetDateTime deletedTime;
    private Integer remainingRetentionDays;
    private ShareAccessTier accessTier;
    private OffsetDateTime accessTierChangeTime;
    private String accessTierStatus;
    private Long shareUsageBytes;
    private LeaseStatus leaseStatus;
    private LeaseState leaseState;
    private LeaseDuration leaseDuration;
    private List<SignedIdentifier> signedIdentifiers;
    private OffsetDateTime snapshotTime;
    private FileSharePropertiesFileSharePaidBursting fileSharePaidBursting;

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public FileShareProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Integer shareQuota() {
        return this.shareQuota;
    }

    public FileShareProperties withShareQuota(Integer shareQuota) {
        this.shareQuota = shareQuota;
        return this;
    }

    public Integer provisionedIops() {
        return this.provisionedIops;
    }

    public FileShareProperties withProvisionedIops(Integer provisionedIops) {
        this.provisionedIops = provisionedIops;
        return this;
    }

    public Integer provisionedBandwidthMibps() {
        return this.provisionedBandwidthMibps;
    }

    public FileShareProperties withProvisionedBandwidthMibps(Integer provisionedBandwidthMibps) {
        this.provisionedBandwidthMibps = provisionedBandwidthMibps;
        return this;
    }

    public Integer includedBurstIops() {
        return this.includedBurstIops;
    }

    public Long maxBurstCreditsForIops() {
        return this.maxBurstCreditsForIops;
    }

    public OffsetDateTime nextAllowedQuotaDowngradeTime() {
        if (this.nextAllowedQuotaDowngradeTime == null) {
            return null;
        }
        return this.nextAllowedQuotaDowngradeTime.getDateTime();
    }

    public OffsetDateTime nextAllowedProvisionedIopsDowngradeTime() {
        if (this.nextAllowedProvisionedIopsDowngradeTime == null) {
            return null;
        }
        return this.nextAllowedProvisionedIopsDowngradeTime.getDateTime();
    }

    public OffsetDateTime nextAllowedProvisionedBandwidthDowngradeTime() {
        if (this.nextAllowedProvisionedBandwidthDowngradeTime == null) {
            return null;
        }
        return this.nextAllowedProvisionedBandwidthDowngradeTime.getDateTime();
    }

    public EnabledProtocols enabledProtocols() {
        return this.enabledProtocols;
    }

    public FileShareProperties withEnabledProtocols(EnabledProtocols enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
        return this;
    }

    public RootSquashType rootSquash() {
        return this.rootSquash;
    }

    public FileShareProperties withRootSquash(RootSquashType rootSquash) {
        this.rootSquash = rootSquash;
        return this;
    }

    public String version() {
        return this.version;
    }

    public Boolean deleted() {
        return this.deleted;
    }

    public OffsetDateTime deletedTime() {
        return this.deletedTime;
    }

    public Integer remainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public ShareAccessTier accessTier() {
        return this.accessTier;
    }

    public FileShareProperties withAccessTier(ShareAccessTier accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    public OffsetDateTime accessTierChangeTime() {
        return this.accessTierChangeTime;
    }

    public String accessTierStatus() {
        return this.accessTierStatus;
    }

    public Long shareUsageBytes() {
        return this.shareUsageBytes;
    }

    public LeaseStatus leaseStatus() {
        return this.leaseStatus;
    }

    public LeaseState leaseState() {
        return this.leaseState;
    }

    public LeaseDuration leaseDuration() {
        return this.leaseDuration;
    }

    public List<SignedIdentifier> signedIdentifiers() {
        return this.signedIdentifiers;
    }

    public FileShareProperties withSignedIdentifiers(List<SignedIdentifier> signedIdentifiers) {
        this.signedIdentifiers = signedIdentifiers;
        return this;
    }

    public OffsetDateTime snapshotTime() {
        return this.snapshotTime;
    }

    public FileSharePropertiesFileSharePaidBursting fileSharePaidBursting() {
        return this.fileSharePaidBursting;
    }

    public FileShareProperties withFileSharePaidBursting(FileSharePropertiesFileSharePaidBursting fileSharePaidBursting) {
        this.fileSharePaidBursting = fileSharePaidBursting;
        return this;
    }

    public void validate() {
        if (this.signedIdentifiers() != null) {
            this.signedIdentifiers().forEach(e -> e.validate());
        }
        if (this.fileSharePaidBursting() != null) {
            this.fileSharePaidBursting().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeNumberField("shareQuota", this.shareQuota);
        jsonWriter.writeNumberField("provisionedIops", this.provisionedIops);
        jsonWriter.writeNumberField("provisionedBandwidthMibps", this.provisionedBandwidthMibps);
        jsonWriter.writeStringField("enabledProtocols", this.enabledProtocols == null ? null : this.enabledProtocols.toString());
        jsonWriter.writeStringField("rootSquash", this.rootSquash == null ? null : this.rootSquash.toString());
        jsonWriter.writeStringField("accessTier", this.accessTier == null ? null : this.accessTier.toString());
        jsonWriter.writeArrayField("signedIdentifiers", this.signedIdentifiers, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("fileSharePaidBursting", this.fileSharePaidBursting);
        return jsonWriter.writeEndObject();
    }

    public static FileShareProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FileShareProperties deserializedFileShareProperties = new FileShareProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedFileShareProperties.lastModifiedTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedFileShareProperties.metadata = metadata;
                    continue;
                }
                if ("shareQuota".equals(fieldName)) {
                    deserializedFileShareProperties.shareQuota = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("provisionedIops".equals(fieldName)) {
                    deserializedFileShareProperties.provisionedIops = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("provisionedBandwidthMibps".equals(fieldName)) {
                    deserializedFileShareProperties.provisionedBandwidthMibps = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("includedBurstIops".equals(fieldName)) {
                    deserializedFileShareProperties.includedBurstIops = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxBurstCreditsForIops".equals(fieldName)) {
                    deserializedFileShareProperties.maxBurstCreditsForIops = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("nextAllowedQuotaDowngradeTime".equals(fieldName)) {
                    deserializedFileShareProperties.nextAllowedQuotaDowngradeTime = reader.getNullable(nonNullReader -> new DateTimeRfc1123(nonNullReader.getString()));
                    continue;
                }
                if ("nextAllowedProvisionedIopsDowngradeTime".equals(fieldName)) {
                    deserializedFileShareProperties.nextAllowedProvisionedIopsDowngradeTime = reader.getNullable(nonNullReader -> new DateTimeRfc1123(nonNullReader.getString()));
                    continue;
                }
                if ("nextAllowedProvisionedBandwidthDowngradeTime".equals(fieldName)) {
                    deserializedFileShareProperties.nextAllowedProvisionedBandwidthDowngradeTime = reader.getNullable(nonNullReader -> new DateTimeRfc1123(nonNullReader.getString()));
                    continue;
                }
                if ("enabledProtocols".equals(fieldName)) {
                    deserializedFileShareProperties.enabledProtocols = EnabledProtocols.fromString(reader.getString());
                    continue;
                }
                if ("rootSquash".equals(fieldName)) {
                    deserializedFileShareProperties.rootSquash = RootSquashType.fromString(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedFileShareProperties.version = reader.getString();
                    continue;
                }
                if ("deleted".equals(fieldName)) {
                    deserializedFileShareProperties.deleted = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("deletedTime".equals(fieldName)) {
                    deserializedFileShareProperties.deletedTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("remainingRetentionDays".equals(fieldName)) {
                    deserializedFileShareProperties.remainingRetentionDays = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("accessTier".equals(fieldName)) {
                    deserializedFileShareProperties.accessTier = ShareAccessTier.fromString(reader.getString());
                    continue;
                }
                if ("accessTierChangeTime".equals(fieldName)) {
                    deserializedFileShareProperties.accessTierChangeTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("accessTierStatus".equals(fieldName)) {
                    deserializedFileShareProperties.accessTierStatus = reader.getString();
                    continue;
                }
                if ("shareUsageBytes".equals(fieldName)) {
                    deserializedFileShareProperties.shareUsageBytes = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("leaseStatus".equals(fieldName)) {
                    deserializedFileShareProperties.leaseStatus = LeaseStatus.fromString(reader.getString());
                    continue;
                }
                if ("leaseState".equals(fieldName)) {
                    deserializedFileShareProperties.leaseState = LeaseState.fromString(reader.getString());
                    continue;
                }
                if ("leaseDuration".equals(fieldName)) {
                    deserializedFileShareProperties.leaseDuration = LeaseDuration.fromString(reader.getString());
                    continue;
                }
                if ("signedIdentifiers".equals(fieldName)) {
                    List<SignedIdentifier> signedIdentifiers = reader.readArray(reader1 -> SignedIdentifier.fromJson(reader1));
                    deserializedFileShareProperties.signedIdentifiers = signedIdentifiers;
                    continue;
                }
                if ("snapshotTime".equals(fieldName)) {
                    deserializedFileShareProperties.snapshotTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("fileSharePaidBursting".equals(fieldName)) {
                    deserializedFileShareProperties.fileSharePaidBursting = FileSharePropertiesFileSharePaidBursting.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFileShareProperties;
        });
    }
}

