/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models.StorageAccountMigrationProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.MigrationStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.SkuName;
import java.io.IOException;

public final class StorageAccountMigrationInner
implements JsonSerializable<StorageAccountMigrationInner> {
    private String id;
    private String name;
    private String type;
    private StorageAccountMigrationProperties innerStorageAccountMigrationDetails = new StorageAccountMigrationProperties();
    private static final ClientLogger LOGGER = new ClientLogger(StorageAccountMigrationInner.class);

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public StorageAccountMigrationInner withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public StorageAccountMigrationInner withType(String type) {
        this.type = type;
        return this;
    }

    private StorageAccountMigrationProperties innerStorageAccountMigrationDetails() {
        return this.innerStorageAccountMigrationDetails;
    }

    public SkuName targetSkuName() {
        return this.innerStorageAccountMigrationDetails() == null ? null : this.innerStorageAccountMigrationDetails().targetSkuName();
    }

    public StorageAccountMigrationInner withTargetSkuName(SkuName targetSkuName) {
        if (this.innerStorageAccountMigrationDetails() == null) {
            this.innerStorageAccountMigrationDetails = new StorageAccountMigrationProperties();
        }
        this.innerStorageAccountMigrationDetails().withTargetSkuName(targetSkuName);
        return this;
    }

    public MigrationStatus migrationStatus() {
        return this.innerStorageAccountMigrationDetails() == null ? null : this.innerStorageAccountMigrationDetails().migrationStatus();
    }

    public String migrationFailedReason() {
        return this.innerStorageAccountMigrationDetails() == null ? null : this.innerStorageAccountMigrationDetails().migrationFailedReason();
    }

    public String migrationFailedDetailedReason() {
        return this.innerStorageAccountMigrationDetails() == null ? null : this.innerStorageAccountMigrationDetails().migrationFailedDetailedReason();
    }

    public void validate() {
        if (this.innerStorageAccountMigrationDetails() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property innerStorageAccountMigrationDetails in model StorageAccountMigrationInner"));
        }
        this.innerStorageAccountMigrationDetails().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerStorageAccountMigrationDetails);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static StorageAccountMigrationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageAccountMigrationInner deserializedStorageAccountMigrationInner = new StorageAccountMigrationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedStorageAccountMigrationInner.innerStorageAccountMigrationDetails = StorageAccountMigrationProperties.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedStorageAccountMigrationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedStorageAccountMigrationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedStorageAccountMigrationInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageAccountMigrationInner;
        });
    }
}

