/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.StorageManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.BlobContainersClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.StorageManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models.BlobContainerInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation.IdParsingUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.BlobContainer;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.ImmutabilityPolicyProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.LeaseDuration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.LeaseState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.LeaseStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.LegalHoldProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.PublicAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.StorageAccount;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

class BlobContainerImpl
extends CreatableUpdatableImpl<BlobContainer, BlobContainerInner, BlobContainerImpl>
implements BlobContainer,
BlobContainer.Definition,
BlobContainer.Update {
    private final StorageManager manager;
    private String resourceGroupName;
    private String accountName;
    private String containerName;
    private PublicAccess cpublicAccess;
    private Map<String, String> cmetadata;
    private PublicAccess upublicAccess;
    private Map<String, String> umetadata;

    BlobContainerImpl(String name, StorageManager manager) {
        super(name, new BlobContainerInner());
        this.manager = manager;
        this.containerName = name;
    }

    BlobContainerImpl(BlobContainerInner inner, StorageManager manager) {
        super(inner.name(), inner);
        this.manager = manager;
        this.containerName = inner.name();
        this.resourceGroupName = IdParsingUtils.getValueFromIdByName(inner.id(), "resourceGroups");
        this.accountName = IdParsingUtils.getValueFromIdByName(inner.id(), "storageAccounts");
        this.containerName = IdParsingUtils.getValueFromIdByName(inner.id(), "containers");
    }

    @Override
    public StorageManager manager() {
        return this.manager;
    }

    @Override
    public Mono<BlobContainer> createResourceAsync() {
        BlobContainersClient client = ((StorageManagementClient)this.manager().serviceClient()).getBlobContainers();
        return client.createAsync(this.resourceGroupName, this.accountName, this.containerName, ((BlobContainerInner)this.innerModel()).withPublicAccess(this.cpublicAccess).withMetadata(this.cmetadata)).map(this.innerToFluentMap(this));
    }

    @Override
    public Mono<BlobContainer> updateResourceAsync() {
        BlobContainersClient client = ((StorageManagementClient)this.manager().serviceClient()).getBlobContainers();
        return client.updateAsync(this.resourceGroupName, this.accountName, this.containerName, ((BlobContainerInner)this.innerModel()).withPublicAccess(this.upublicAccess).withMetadata(this.umetadata)).map(this.innerToFluentMap(this));
    }

    @Override
    protected Mono<BlobContainerInner> getInnerAsync() {
        return ((StorageManagementClient)this.manager().serviceClient()).getBlobContainers().getAsync(this.resourceGroupName, this.accountName, this.containerName);
    }

    @Override
    public boolean isInCreateMode() {
        return ((BlobContainerInner)this.innerModel()).id() == null;
    }

    @Override
    public String etag() {
        return ((BlobContainerInner)this.innerModel()).etag();
    }

    @Override
    public Boolean hasImmutabilityPolicy() {
        return ((BlobContainerInner)this.innerModel()).hasImmutabilityPolicy();
    }

    @Override
    public Boolean hasLegalHold() {
        return ((BlobContainerInner)this.innerModel()).hasLegalHold();
    }

    @Override
    public String id() {
        return ((BlobContainerInner)this.innerModel()).id();
    }

    @Override
    public ImmutabilityPolicyProperties immutabilityPolicy() {
        return ((BlobContainerInner)this.innerModel()).immutabilityPolicy();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return ((BlobContainerInner)this.innerModel()).lastModifiedTime();
    }

    @Override
    public LeaseDuration leaseDuration() {
        return ((BlobContainerInner)this.innerModel()).leaseDuration();
    }

    @Override
    public LeaseState leaseState() {
        return ((BlobContainerInner)this.innerModel()).leaseState();
    }

    @Override
    public LeaseStatus leaseStatus() {
        return ((BlobContainerInner)this.innerModel()).leaseStatus();
    }

    @Override
    public LegalHoldProperties legalHold() {
        return ((BlobContainerInner)this.innerModel()).legalHold();
    }

    @Override
    public Map<String, String> metadata() {
        return ((BlobContainerInner)this.innerModel()).metadata();
    }

    @Override
    public String name() {
        return ((BlobContainerInner)this.innerModel()).name();
    }

    @Override
    public PublicAccess publicAccess() {
        return ((BlobContainerInner)this.innerModel()).publicAccess();
    }

    @Override
    public String type() {
        return ((BlobContainerInner)this.innerModel()).type();
    }

    @Override
    public BlobContainerImpl withExistingBlobService(String resourceGroupName, String accountName) {
        this.withExistingStorageAccount(resourceGroupName, accountName);
        return this;
    }

    @Override
    public BlobContainer.DefinitionStages.WithPublicAccess withExistingStorageAccount(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public BlobContainer.DefinitionStages.WithPublicAccess withExistingStorageAccount(StorageAccount storageAccount) {
        this.withExistingStorageAccount(storageAccount.resourceGroupName(), storageAccount.name());
        return this;
    }

    @Override
    public BlobContainerImpl withPublicAccess(PublicAccess publicAccess) {
        if (this.isInCreateMode()) {
            this.cpublicAccess = publicAccess;
        } else {
            this.upublicAccess = publicAccess;
        }
        return this;
    }

    @Override
    public BlobContainerImpl withMetadata(Map<String, String> metadata) {
        if (this.isInCreateMode()) {
            this.cmetadata = metadata;
        } else {
            this.umetadata = metadata;
        }
        return this;
    }

    @Override
    public BlobContainerImpl withMetadata(String name, String value) {
        if (this.isInCreateMode()) {
            if (this.cmetadata == null) {
                this.cmetadata = new HashMap<String, String>();
            }
            this.cmetadata.put(name, value);
        } else {
            if (this.umetadata == null) {
                this.umetadata = new HashMap<String, String>();
            }
            this.umetadata.put(name, value);
        }
        return this;
    }
}

