/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.StorageTaskAssignmentsInstancesReportsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models.StorageTaskReportInstanceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.implementation.StorageManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.StorageTaskReportSummary;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class StorageTaskAssignmentsInstancesReportsClientImpl
implements StorageTaskAssignmentsInstancesReportsClient {
    private final StorageTaskAssignmentsInstancesReportsService service;
    private final StorageManagementClientImpl client;

    StorageTaskAssignmentsInstancesReportsClientImpl(StorageManagementClientImpl client) {
        this.service = RestProxy.create(StorageTaskAssignmentsInstancesReportsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<StorageTaskReportInstanceInner>> listSinglePageAsync(String resourceGroupName, String accountName, Integer maxpagesize, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, maxpagesize, filter, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, StorageTaskReportInstanceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StorageTaskReportSummary)res.getValue()).value(), ((StorageTaskReportSummary)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<StorageTaskReportInstanceInner>> listSinglePageAsync(String resourceGroupName, String accountName, Integer maxpagesize, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, maxpagesize, filter, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, StorageTaskReportInstanceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StorageTaskReportSummary)res.getValue()).value(), ((StorageTaskReportSummary)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<StorageTaskReportInstanceInner> listAsync(String resourceGroupName, String accountName, Integer maxpagesize, String filter) {
        return new PagedFlux<StorageTaskReportInstanceInner>(() -> this.listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<StorageTaskReportInstanceInner> listAsync(String resourceGroupName, String accountName) {
        Integer maxpagesize = null;
        String filter = null;
        return new PagedFlux<StorageTaskReportInstanceInner>(() -> this.listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<StorageTaskReportInstanceInner> listAsync(String resourceGroupName, String accountName, Integer maxpagesize, String filter, Context context) {
        return new PagedFlux<StorageTaskReportInstanceInner>(() -> this.listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<StorageTaskReportInstanceInner> list(String resourceGroupName, String accountName) {
        Integer maxpagesize = null;
        String filter = null;
        return new PagedIterable<StorageTaskReportInstanceInner>(this.listAsync(resourceGroupName, accountName, maxpagesize, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<StorageTaskReportInstanceInner> list(String resourceGroupName, String accountName, Integer maxpagesize, String filter, Context context) {
        return new PagedIterable<StorageTaskReportInstanceInner>(this.listAsync(resourceGroupName, accountName, maxpagesize, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<StorageTaskReportInstanceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, StorageTaskReportInstanceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StorageTaskReportSummary)res.getValue()).value(), ((StorageTaskReportSummary)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<StorageTaskReportInstanceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, StorageTaskReportInstanceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((StorageTaskReportSummary)res.getValue()).value(), ((StorageTaskReportSummary)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="StorageManagementCli")
    public static interface StorageTaskAssignmentsInstancesReportsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/reports")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<StorageTaskReportSummary>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @QueryParam(value="$maxpagesize") Integer var5, @QueryParam(value="$filter") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<StorageTaskReportSummary>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

