/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.EncryptionIdentity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.EncryptionServices;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.KeySource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.KeyVaultProperties;
import java.io.IOException;

public final class Encryption
implements JsonSerializable<Encryption> {
    private EncryptionServices services;
    private KeySource keySource;
    private Boolean requireInfrastructureEncryption;
    private KeyVaultProperties keyVaultProperties;
    private EncryptionIdentity encryptionIdentity;

    public EncryptionServices services() {
        return this.services;
    }

    public Encryption withServices(EncryptionServices services) {
        this.services = services;
        return this;
    }

    public KeySource keySource() {
        return this.keySource;
    }

    public Encryption withKeySource(KeySource keySource) {
        this.keySource = keySource;
        return this;
    }

    public Boolean requireInfrastructureEncryption() {
        return this.requireInfrastructureEncryption;
    }

    public Encryption withRequireInfrastructureEncryption(Boolean requireInfrastructureEncryption) {
        this.requireInfrastructureEncryption = requireInfrastructureEncryption;
        return this;
    }

    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public Encryption withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public EncryptionIdentity encryptionIdentity() {
        return this.encryptionIdentity;
    }

    public Encryption withEncryptionIdentity(EncryptionIdentity encryptionIdentity) {
        this.encryptionIdentity = encryptionIdentity;
        return this;
    }

    public void validate() {
        if (this.services() != null) {
            this.services().validate();
        }
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().validate();
        }
        if (this.encryptionIdentity() != null) {
            this.encryptionIdentity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("services", this.services);
        jsonWriter.writeStringField("keySource", this.keySource == null ? null : this.keySource.toString());
        jsonWriter.writeBooleanField("requireInfrastructureEncryption", this.requireInfrastructureEncryption);
        jsonWriter.writeJsonField("keyvaultproperties", this.keyVaultProperties);
        jsonWriter.writeJsonField("identity", this.encryptionIdentity);
        return jsonWriter.writeEndObject();
    }

    public static Encryption fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Encryption deserializedEncryption = new Encryption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("services".equals(fieldName)) {
                    deserializedEncryption.services = EncryptionServices.fromJson(reader);
                    continue;
                }
                if ("keySource".equals(fieldName)) {
                    deserializedEncryption.keySource = KeySource.fromString(reader.getString());
                    continue;
                }
                if ("requireInfrastructureEncryption".equals(fieldName)) {
                    deserializedEncryption.requireInfrastructureEncryption = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("keyvaultproperties".equals(fieldName)) {
                    deserializedEncryption.keyVaultProperties = KeyVaultProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedEncryption.encryptionIdentity = EncryptionIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryption;
        });
    }
}

