/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;

public final class PermissionScope
implements JsonSerializable<PermissionScope> {
    private String permissions;
    private String service;
    private String resourceName;
    private static final ClientLogger LOGGER = new ClientLogger(PermissionScope.class);

    public String permissions() {
        return this.permissions;
    }

    public PermissionScope withPermissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    public String service() {
        return this.service;
    }

    public PermissionScope withService(String service) {
        this.service = service;
        return this;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public PermissionScope withResourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    public void validate() {
        if (this.permissions() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property permissions in model PermissionScope"));
        }
        if (this.service() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property service in model PermissionScope"));
        }
        if (this.resourceName() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property resourceName in model PermissionScope"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("permissions", this.permissions);
        jsonWriter.writeStringField("service", this.service);
        jsonWriter.writeStringField("resourceName", this.resourceName);
        return jsonWriter.writeEndObject();
    }

    public static PermissionScope fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PermissionScope deserializedPermissionScope = new PermissionScope();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("permissions".equals(fieldName)) {
                    deserializedPermissionScope.permissions = reader.getString();
                    continue;
                }
                if ("service".equals(fieldName)) {
                    deserializedPermissionScope.service = reader.getString();
                    continue;
                }
                if ("resourceName".equals(fieldName)) {
                    deserializedPermissionScope.resourceName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPermissionScope;
        });
    }
}

