/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.KeyPermission;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class StorageAccountKey
implements JsonSerializable<StorageAccountKey> {
    private String keyName;
    private String value;
    private KeyPermission permissions;
    private OffsetDateTime creationTime;

    public String keyName() {
        return this.keyName;
    }

    public String value() {
        return this.value;
    }

    public KeyPermission permissions() {
        return this.permissions;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static StorageAccountKey fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageAccountKey deserializedStorageAccountKey = new StorageAccountKey();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyName".equals(fieldName)) {
                    deserializedStorageAccountKey.keyName = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedStorageAccountKey.value = reader.getString();
                    continue;
                }
                if ("permissions".equals(fieldName)) {
                    deserializedStorageAccountKey.permissions = KeyPermission.fromString(reader.getString());
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedStorageAccountKey.creationTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageAccountKey;
        });
    }
}

