/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class TableAccessPolicy
implements JsonSerializable<TableAccessPolicy> {
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permission;
    private static final ClientLogger LOGGER = new ClientLogger(TableAccessPolicy.class);

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public TableAccessPolicy withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public TableAccessPolicy withExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public String permission() {
        return this.permission;
    }

    public TableAccessPolicy withPermission(String permission) {
        this.permission = permission;
        return this;
    }

    public void validate() {
        if (this.permission() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property permission in model TableAccessPolicy"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("permission", this.permission);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("expiryTime", this.expiryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiryTime));
        return jsonWriter.writeEndObject();
    }

    public static TableAccessPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TableAccessPolicy deserializedTableAccessPolicy = new TableAccessPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("permission".equals(fieldName)) {
                    deserializedTableAccessPolicy.permission = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedTableAccessPolicy.startTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("expiryTime".equals(fieldName)) {
                    deserializedTableAccessPolicy.expiryTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTableAccessPolicy;
        });
    }
}

