/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.TableAccessPolicy;
import java.io.IOException;

public final class TableSignedIdentifier
implements JsonSerializable<TableSignedIdentifier> {
    private String id;
    private TableAccessPolicy accessPolicy;
    private static final ClientLogger LOGGER = new ClientLogger(TableSignedIdentifier.class);

    public String id() {
        return this.id;
    }

    public TableSignedIdentifier withId(String id) {
        this.id = id;
        return this;
    }

    public TableAccessPolicy accessPolicy() {
        return this.accessPolicy;
    }

    public TableSignedIdentifier withAccessPolicy(TableAccessPolicy accessPolicy) {
        this.accessPolicy = accessPolicy;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property id in model TableSignedIdentifier"));
        }
        if (this.accessPolicy() != null) {
            this.accessPolicy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("accessPolicy", this.accessPolicy);
        return jsonWriter.writeEndObject();
    }

    public static TableSignedIdentifier fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TableSignedIdentifier deserializedTableSignedIdentifier = new TableSignedIdentifier();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTableSignedIdentifier.id = reader.getString();
                    continue;
                }
                if ("accessPolicy".equals(fieldName)) {
                    deserializedTableSignedIdentifier.accessPolicy = TableAccessPolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTableSignedIdentifier;
        });
    }
}

