/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.IntervalUnit;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class TriggerParametersUpdate
implements JsonSerializable<TriggerParametersUpdate> {
    private OffsetDateTime startFrom;
    private Integer interval;
    private IntervalUnit intervalUnit;
    private OffsetDateTime endBy;
    private OffsetDateTime startOn;

    public OffsetDateTime startFrom() {
        return this.startFrom;
    }

    public TriggerParametersUpdate withStartFrom(OffsetDateTime startFrom) {
        this.startFrom = startFrom;
        return this;
    }

    public Integer interval() {
        return this.interval;
    }

    public TriggerParametersUpdate withInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    public IntervalUnit intervalUnit() {
        return this.intervalUnit;
    }

    public TriggerParametersUpdate withIntervalUnit(IntervalUnit intervalUnit) {
        this.intervalUnit = intervalUnit;
        return this;
    }

    public OffsetDateTime endBy() {
        return this.endBy;
    }

    public TriggerParametersUpdate withEndBy(OffsetDateTime endBy) {
        this.endBy = endBy;
        return this;
    }

    public OffsetDateTime startOn() {
        return this.startOn;
    }

    public TriggerParametersUpdate withStartOn(OffsetDateTime startOn) {
        this.startOn = startOn;
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startFrom", this.startFrom == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startFrom));
        jsonWriter.writeNumberField("interval", this.interval);
        jsonWriter.writeStringField("intervalUnit", this.intervalUnit == null ? null : this.intervalUnit.toString());
        jsonWriter.writeStringField("endBy", this.endBy == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endBy));
        jsonWriter.writeStringField("startOn", this.startOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startOn));
        return jsonWriter.writeEndObject();
    }

    public static TriggerParametersUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TriggerParametersUpdate deserializedTriggerParametersUpdate = new TriggerParametersUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startFrom".equals(fieldName)) {
                    deserializedTriggerParametersUpdate.startFrom = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    deserializedTriggerParametersUpdate.interval = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("intervalUnit".equals(fieldName)) {
                    deserializedTriggerParametersUpdate.intervalUnit = IntervalUnit.fromString(reader.getString());
                    continue;
                }
                if ("endBy".equals(fieldName)) {
                    deserializedTriggerParametersUpdate.endBy = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("startOn".equals(fieldName)) {
                    deserializedTriggerParametersUpdate.startOn = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTriggerParametersUpdate;
        });
    }
}

