/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.SimpleResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.LongRunningOperationStatus;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollingContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.KeyAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.KeyClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.KeyServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.KeyClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.KeyVaultKeysUtils;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.BackupKeyResult;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.DeletedKeyBundle;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyBundle;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyVaultErrorException;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyVaultKeysModelsUtils;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.RandomBytes;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.CreateEcKeyOptions;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.CreateKeyOptions;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.CreateOctKeyOptions;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.CreateRsaKeyOptions;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.DeletedKey;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.ImportKeyOptions;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.JsonWebKey;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyExportEncryptionAlgorithm;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyOperation;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyProperties;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyRotationPolicy;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyType;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyVaultKey;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.ReleaseKeyOptions;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.ReleaseKeyResult;
import java.time.Duration;
import java.util.Arrays;
import java.util.function.Function;

@ServiceClient(builder=KeyClientBuilder.class, serviceInterfaces={KeyClientImpl.KeyClientService.class})
public final class KeyClient {
    private static final ClientLogger LOGGER = new ClientLogger(KeyClient.class);
    private final KeyClientImpl implClient;
    private final String vaultUrl;
    private final KeyServiceVersion serviceVersion;

    KeyClient(KeyClientImpl implClient, String vaultUrl, KeyServiceVersion serviceVersion) {
        this.implClient = implClient;
        this.vaultUrl = vaultUrl;
        this.serviceVersion = serviceVersion;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    HttpPipeline getHttpPipeline() {
        return this.implClient.getHttpPipeline();
    }

    public CryptographyClient getCryptographyClient(String keyName) {
        return this.getCryptographyClient(keyName, null);
    }

    public CryptographyClient getCryptographyClient(String keyName, String keyVersion) {
        return KeyVaultKeysUtils.getCryptographyClientBuilder(keyName, keyVersion, this.vaultUrl, this.getHttpPipeline(), this.serviceVersion).buildClient();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createKey(String name, KeyType keyType) {
        return this.createKeyWithResponse(new CreateKeyOptions(name, keyType), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createKey(CreateKeyOptions createKeyOptions) {
        return this.createKeyWithResponse(createKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> createKeyWithResponse(CreateKeyOptions createKeyOptions, Context context) {
        if (createKeyOptions == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'createKeyOptions' cannot be null."));
        }
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.createKeyWithResponse(this.vaultUrl, createKeyOptions.getName(), createKeyOptions.getKeyType(), null, null, createKeyOptions.getKeyOperations(), KeyVaultKeysModelsUtils.createKeyAttributes(createKeyOptions), createKeyOptions.getTags(), null, KeyVaultKeysModelsUtils.mapKeyReleasePolicy(createKeyOptions.getReleasePolicy()), context), KeyAsyncClient::mapCreateKeyException);
        return new SimpleResponse<KeyVaultKey>(response, KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createRsaKey(CreateRsaKeyOptions createRsaKeyOptions) {
        return this.createRsaKeyWithResponse(createRsaKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> createRsaKeyWithResponse(CreateRsaKeyOptions createRsaKeyOptions, Context context) {
        if (createRsaKeyOptions == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'createRsaKeyOptions' cannot be null."));
        }
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.createKeyWithResponse(this.vaultUrl, createRsaKeyOptions.getName(), createRsaKeyOptions.getKeyType(), createRsaKeyOptions.getKeySize(), createRsaKeyOptions.getPublicExponent(), createRsaKeyOptions.getKeyOperations(), KeyVaultKeysModelsUtils.createKeyAttributes(createRsaKeyOptions), createRsaKeyOptions.getTags(), null, KeyVaultKeysModelsUtils.mapKeyReleasePolicy(createRsaKeyOptions.getReleasePolicy()), context), KeyAsyncClient::mapCreateKeyException);
        return new SimpleResponse<KeyVaultKey>(response, KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createEcKey(CreateEcKeyOptions createEcKeyOptions) {
        return this.createEcKeyWithResponse(createEcKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> createEcKeyWithResponse(CreateEcKeyOptions createEcKeyOptions, Context context) {
        if (createEcKeyOptions == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'createEcKeyOptions' cannot be null."));
        }
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.createKeyWithResponse(this.vaultUrl, createEcKeyOptions.getName(), createEcKeyOptions.getKeyType(), null, null, createEcKeyOptions.getKeyOperations(), KeyVaultKeysModelsUtils.createKeyAttributes(createEcKeyOptions), createEcKeyOptions.getTags(), createEcKeyOptions.getCurveName(), KeyVaultKeysModelsUtils.mapKeyReleasePolicy(createEcKeyOptions.getReleasePolicy()), context), KeyAsyncClient::mapCreateKeyException);
        return new SimpleResponse<KeyVaultKey>(response, KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey createOctKey(CreateOctKeyOptions createOctKeyOptions) {
        return this.createOctKeyWithResponse(createOctKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> createOctKeyWithResponse(CreateOctKeyOptions createOctKeyOptions, Context context) {
        if (createOctKeyOptions == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'createOctKeyOptions' cannot be null."));
        }
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.createKeyWithResponse(this.vaultUrl, createOctKeyOptions.getName(), createOctKeyOptions.getKeyType(), createOctKeyOptions.getKeySize(), null, createOctKeyOptions.getKeyOperations(), KeyVaultKeysModelsUtils.createKeyAttributes(createOctKeyOptions), createOctKeyOptions.getTags(), null, KeyVaultKeysModelsUtils.mapKeyReleasePolicy(createOctKeyOptions.getReleasePolicy()), context), KeyAsyncClient::mapCreateKeyException);
        return new SimpleResponse<KeyVaultKey>(response, KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey importKey(String name, JsonWebKey keyMaterial) {
        return this.importKeyWithResponse(new ImportKeyOptions(name, keyMaterial), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey importKey(ImportKeyOptions importKeyOptions) {
        return this.importKeyWithResponse(importKeyOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> importKeyWithResponse(ImportKeyOptions importKeyOptions, Context context) {
        if (importKeyOptions == null) {
            throw LOGGER.logExceptionAsError(new RuntimeException("'importKeyOptions' cannot be null."));
        }
        Response<KeyBundle> response = this.implClient.importKeyWithResponse(this.vaultUrl, importKeyOptions.getName(), KeyVaultKeysModelsUtils.mapJsonWebKey(importKeyOptions.getKey()), importKeyOptions.isHardwareProtected(), KeyVaultKeysModelsUtils.createKeyAttributes(importKeyOptions), importKeyOptions.getTags(), KeyVaultKeysModelsUtils.mapKeyReleasePolicy(importKeyOptions.getReleasePolicy()), context);
        return new SimpleResponse<KeyVaultKey>(response, KeyVaultKeysModelsUtils.createKeyVaultKey(response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey getKey(String name, String version) {
        return this.getKeyWithResponse(name, version, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> getKeyWithResponse(String name, String version, Context context) {
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.getKeyWithResponse(this.vaultUrl, name, version, context), KeyVaultKeysUtils::mapGetKeyException);
        return new SimpleResponse<KeyVaultKey>(response, KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey getKey(String name) {
        return this.getKeyWithResponse(name, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey updateKeyProperties(KeyProperties keyProperties, KeyOperation ... keyOperations) {
        return this.updateKeyPropertiesWithResponse(keyProperties, Context.NONE, keyOperations).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> updateKeyPropertiesWithResponse(KeyProperties keyProperties, Context context, KeyOperation ... keyOperations) {
        if (keyProperties == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'keyProperties' cannot be null."));
        }
        Response<KeyBundle> response = this.implClient.updateKeyWithResponse(this.vaultUrl, keyProperties.getName(), keyProperties.getVersion(), keyOperations == null ? null : Arrays.asList(keyOperations), KeyVaultKeysModelsUtils.createKeyAttributes(keyProperties), keyProperties.getTags(), KeyVaultKeysModelsUtils.mapKeyReleasePolicy(keyProperties.getReleasePolicy()), context);
        return new SimpleResponse<KeyVaultKey>(response, KeyVaultKeysModelsUtils.createKeyVaultKey(response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DeletedKey, Void> beginDeleteKey(String name) {
        return SyncPoller.createPoller(Duration.ofSeconds(1L), this.deleteActivationOperation(name), this.deletePollOperation(name), (pollingContext, firstResponse) -> null, pollingContext -> null);
    }

    private Function<PollingContext<DeletedKey>, PollResponse<DeletedKey>> deleteActivationOperation(String name) {
        return pollingContext -> new PollResponse<DeletedKey>(LongRunningOperationStatus.NOT_STARTED, KeyVaultKeysUtils.callWithMappedException(() -> KeyVaultKeysModelsUtils.createDeletedKey(this.implClient.deleteKey(this.vaultUrl, name)), KeyAsyncClient::mapDeleteKeyException));
    }

    private Function<PollingContext<DeletedKey>, PollResponse<DeletedKey>> deletePollOperation(String name) {
        return pollingContext -> {
            try {
                return new PollResponse<DeletedKey>(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, KeyVaultKeysModelsUtils.createDeletedKey(this.implClient.getDeletedKey(this.vaultUrl, name)));
            }
            catch (KeyVaultErrorException ex) {
                if (ex.getResponse().getStatusCode() == 404) {
                    return new PollResponse<DeletedKey>(LongRunningOperationStatus.IN_PROGRESS, (DeletedKey)pollingContext.getLatestResponse().getValue());
                }
                return new PollResponse<DeletedKey>(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (DeletedKey)pollingContext.getLatestResponse().getValue());
            }
            catch (RuntimeException ex) {
                return new PollResponse<DeletedKey>(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (DeletedKey)pollingContext.getLatestResponse().getValue());
            }
        };
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedKey getDeletedKey(String name) {
        return this.getDeletedKeyWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedKey> getDeletedKeyWithResponse(String name, Context context) {
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.getDeletedKeyWithResponse(this.vaultUrl, name, context), KeyAsyncClient::mapGetDeletedKeyException);
        return new SimpleResponse<DeletedKey>(response, KeyVaultKeysModelsUtils.createDeletedKey((DeletedKeyBundle)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeDeletedKey(String name) {
        this.purgeDeletedKeyWithResponse(name, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> purgeDeletedKeyWithResponse(String name, Context context) {
        return KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.purgeDeletedKeyWithResponse(this.vaultUrl, name, context), KeyAsyncClient::mapPurgeDeletedKeyException);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<KeyVaultKey, Void> beginRecoverDeletedKey(String name) {
        return SyncPoller.createPoller(Duration.ofSeconds(1L), this.recoverActivationOperation(name), this.recoverPollOperation(name), (pollingContext, firstResponse) -> null, pollingContext -> null);
    }

    private Function<PollingContext<KeyVaultKey>, PollResponse<KeyVaultKey>> recoverActivationOperation(String name) {
        return pollingContext -> new PollResponse<KeyVaultKey>(LongRunningOperationStatus.NOT_STARTED, KeyVaultKeysModelsUtils.createKeyVaultKey(KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.recoverDeletedKey(this.vaultUrl, name), KeyAsyncClient::mapRecoverDeletedKeyException)));
    }

    private Function<PollingContext<KeyVaultKey>, PollResponse<KeyVaultKey>> recoverPollOperation(String keyName) {
        return pollingContext -> {
            try {
                return new PollResponse<KeyVaultKey>(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, KeyVaultKeysModelsUtils.createKeyVaultKey(this.implClient.getKey(this.vaultUrl, keyName, null)));
            }
            catch (KeyVaultErrorException ex) {
                if (ex.getResponse().getStatusCode() == 404) {
                    return new PollResponse<KeyVaultKey>(LongRunningOperationStatus.IN_PROGRESS, (KeyVaultKey)pollingContext.getLatestResponse().getValue());
                }
                return new PollResponse<KeyVaultKey>(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (KeyVaultKey)pollingContext.getLatestResponse().getValue());
            }
            catch (RuntimeException ex) {
                return new PollResponse<KeyVaultKey>(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (KeyVaultKey)pollingContext.getLatestResponse().getValue());
            }
        };
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] backupKey(String name) {
        return this.backupKeyWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<byte[]> backupKeyWithResponse(String name, Context context) {
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.backupKeyWithResponse(this.vaultUrl, name, context), KeyAsyncClient::mapBackupKeyException);
        return new SimpleResponse<byte[]>(response, ((BackupKeyResult)response.getValue()).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey restoreKeyBackup(byte[] backup) {
        return this.restoreKeyBackupWithResponse(backup, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> restoreKeyBackupWithResponse(byte[] backup, Context context) {
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.restoreKeyWithResponse(this.vaultUrl, backup, context), KeyAsyncClient::mapRestoreKeyException);
        return new SimpleResponse<KeyVaultKey>(response, KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyProperties> listPropertiesOfKeys() {
        return this.listPropertiesOfKeys(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyProperties> listPropertiesOfKeys(Context context) {
        return new PagedIterable<KeyProperties>(maxResults -> KeyAsyncClient.mapKeyItemPagedResponse(this.implClient.getKeysSinglePage(this.vaultUrl, (Integer)maxResults, context)), (continuationToken, maxResults) -> KeyAsyncClient.mapKeyItemPagedResponse(this.implClient.getKeysNextSinglePage((String)continuationToken, this.vaultUrl, context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedKey> listDeletedKeys() {
        return this.listDeletedKeys(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedKey> listDeletedKeys(Context context) {
        return new PagedIterable<DeletedKey>(maxResults -> KeyAsyncClient.mapDeletedKeyItemPagedResponse(this.implClient.getDeletedKeysSinglePage(this.vaultUrl, (Integer)maxResults, context)), (continuationToken, maxResults) -> KeyAsyncClient.mapDeletedKeyItemPagedResponse(this.implClient.getDeletedKeysNextSinglePage((String)continuationToken, this.vaultUrl, context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyProperties> listPropertiesOfKeyVersions(String name) {
        return this.listPropertiesOfKeyVersions(name, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyProperties> listPropertiesOfKeyVersions(String name, Context context) {
        return new PagedIterable<KeyProperties>(maxResults -> KeyAsyncClient.mapKeyItemPagedResponse(this.implClient.getKeyVersionsSinglePage(this.vaultUrl, name, (Integer)maxResults, context)), (continuationToken, maxResults) -> KeyAsyncClient.mapKeyItemPagedResponse(this.implClient.getKeyVersionsNextSinglePage((String)continuationToken, this.vaultUrl, context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] getRandomBytes(int count) {
        return this.getRandomBytesWithResponse(count, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<byte[]> getRandomBytesWithResponse(int count, Context context) {
        Response<RandomBytes> response = this.implClient.getRandomBytesWithResponse(this.vaultUrl, count, context);
        return new SimpleResponse<byte[]>(response, response.getValue().getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ReleaseKeyResult releaseKey(String name, String targetAttestationToken) {
        return this.releaseKeyWithResponse(name, null, targetAttestationToken, new ReleaseKeyOptions(), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ReleaseKeyResult releaseKey(String name, String version, String targetAttestationToken) {
        return this.releaseKeyWithResponse(name, version, targetAttestationToken, new ReleaseKeyOptions(), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ReleaseKeyResult> releaseKeyWithResponse(String name, String version, String targetAttestationToken, ReleaseKeyOptions releaseKeyOptions, Context context) {
        if (CoreUtils.isNullOrEmpty(name) || CoreUtils.isNullOrEmpty(targetAttestationToken)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'name' or 'targetAttestationToken' cannot be null or empty."));
        }
        String nonce = releaseKeyOptions == null ? null : releaseKeyOptions.getNonce();
        KeyExportEncryptionAlgorithm algorithm = releaseKeyOptions == null ? null : releaseKeyOptions.getAlgorithm();
        return KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.releaseWithResponse(this.vaultUrl, name, version, targetAttestationToken, nonce, algorithm, context), KeyAsyncClient::mapReleaseKeyException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultKey rotateKey(String name) {
        return this.rotateKeyWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultKey> rotateKeyWithResponse(String name, Context context) {
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.rotateKeyWithResponse(this.vaultUrl, name, context), KeyAsyncClient::mapRotateKeyException);
        return new SimpleResponse<KeyVaultKey>(response, KeyVaultKeysModelsUtils.createKeyVaultKey((KeyBundle)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyRotationPolicy getKeyRotationPolicy(String keyName) {
        return this.getKeyRotationPolicyWithResponse(keyName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyRotationPolicy> getKeyRotationPolicyWithResponse(String keyName, Context context) {
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.getKeyRotationPolicyWithResponse(this.vaultUrl, keyName, context), KeyAsyncClient::mapGetKeyRotationPolicyException);
        return new SimpleResponse<KeyRotationPolicy>(response, KeyVaultKeysModelsUtils.mapKeyRotationPolicyImpl((com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyRotationPolicy updateKeyRotationPolicy(String keyName, KeyRotationPolicy keyRotationPolicy) {
        return this.updateKeyRotationPolicyWithResponse(keyName, keyRotationPolicy, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyRotationPolicy> updateKeyRotationPolicyWithResponse(String keyName, KeyRotationPolicy keyRotationPolicy, Context context) {
        Response response = KeyVaultKeysUtils.callWithMappedException(() -> this.implClient.updateKeyRotationPolicyWithResponse(this.vaultUrl, keyName, KeyVaultKeysModelsUtils.mapKeyRotationPolicy(keyRotationPolicy), context), KeyAsyncClient::mapUpdateKeyRotationPolicyException);
        return new SimpleResponse<KeyRotationPolicy>(response, KeyVaultKeysModelsUtils.mapKeyRotationPolicyImpl((com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy)response.getValue()));
    }
}

